/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.core.sasl.handler;

import org.apache.vysper.xml.fragment.XMLElementVerifier;
import org.apache.vysper.xmpp.modules.core.sasl.AuthorizationRetriesCounter;
import org.apache.vysper.xmpp.modules.core.sasl.SASLFailureType;
import org.apache.vysper.xmpp.protocol.ResponseStanzaContainer;
import org.apache.vysper.xmpp.protocol.ResponseStanzaContainerImpl;
import org.apache.vysper.xmpp.protocol.SessionStateHolder;
import org.apache.vysper.xmpp.protocol.StanzaHandler;
import org.apache.vysper.xmpp.protocol.StreamErrorCondition;
import org.apache.vysper.xmpp.protocol.exception.AuthorizationFailedException;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.SessionState;
import org.apache.vysper.xmpp.server.response.ServerErrorResponses;
import org.apache.vysper.xmpp.stanza.Stanza;

public abstract class AbstractSASLHandler
implements StanzaHandler {
    public boolean verify(Stanza stanza) {
        if (stanza == null) {
            return false;
        }
        return this.getName().equals(stanza.getName());
    }

    public ResponseStanzaContainer execute(Stanza stanza, ServerRuntimeContext serverRuntimeContext, boolean isOutboundStanza, SessionContext sessionContext, SessionStateHolder sessionStateHolder) throws AuthorizationFailedException {
        if (!AuthorizationRetriesCounter.getFromSession(sessionContext).hasTriesLeft()) {
            AuthorizationFailedException failedException = new AuthorizationFailedException("too many retries");
            failedException.setErrorStanza(ServerErrorResponses.getStreamError(StreamErrorCondition.POLICY_VIOLATION, null, null, null));
            throw failedException;
        }
        XMLElementVerifier xmlElementVerifier = stanza.getVerifier();
        boolean saslNamespace = xmlElementVerifier.namespacePresent("urn:ietf:params:xml:ns:xmpp-sasl");
        if (!saslNamespace) {
            return this.respondSASLFailure();
        }
        if (sessionStateHolder.getState() != SessionState.ENCRYPTED) {
            return this.respondSASLFailure();
        }
        return this.executeWorker(stanza, sessionContext, sessionStateHolder);
    }

    protected ResponseStanzaContainer respondSASLFailure() {
        return new ResponseStanzaContainerImpl(ServerErrorResponses.getSASLFailure(SASLFailureType.MALFORMED_REQUEST));
    }

    protected abstract ResponseStanzaContainer executeWorker(Stanza var1, SessionContext var2, SessionStateHolder var3);
}

