/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0220_server_dailback;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.vysper.xmpp.addressing.Entity;

public class DialbackIdGenerator {
    private static final String SECRET = UUID.randomUUID().toString();
    private SecretKeySpec signingKey = new SecretKeySpec(DigestUtils.sha256((String)SECRET), "HmacSHA256");
    private Mac mac;

    public DialbackIdGenerator() {
        try {
            this.mac = Mac.getInstance("HmacSHA256");
            this.mac.init(this.signingKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
    }

    public String generate(Entity receiving, Entity originating, String streamId) {
        try {
            this.mac.update(receiving.getDomain().getBytes("UTF-16"));
            this.mac.update(" ".getBytes("UTF-16"));
            this.mac.update(originating.getDomain().getBytes("UTF-16"));
            this.mac.update(" ".getBytes("UTF-16"));
            this.mac.update(streamId.getBytes("UTF-16"));
            byte[] rawHmac = this.mac.doFinal();
            return Hex.encodeHexString((byte[])rawHmac);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean verify(String dailbackId, Entity receiving, Entity originating, String streamId) {
        return dailbackId.equals(this.generate(receiving, originating, streamId));
    }
}

