/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0045_muc.stanzas;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.vysper.xml.fragment.Attribute;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xml.fragment.XMLSemanticError;
import org.apache.vysper.xmpp.datetime.DateTimeProfile;
import org.apache.vysper.xmpp.stanza.Stanza;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class History
extends XMLElement {
    private static final String ELEMENT_HISTORY = "history";
    private static final String ATTRIBUTE_SINCE = "since";
    private static final String ATTRIBUTE_SECONDS = "seconds";
    private static final String ATTRIBUTE_MAXCHARS = "maxchars";
    private static final String ATTRIBUTE_MAXSTANZAS = "maxstanzas";

    public static History fromStanza(Stanza stanza) {
        try {
            XMLElement historyElm;
            XMLElement xElm = stanza.getSingleInnerElementsNamed("x", "http://jabber.org/protocol/muc");
            if (xElm != null && (historyElm = xElm.getSingleInnerElementsNamed(ELEMENT_HISTORY)) != null) {
                return new History(historyElm);
            }
            return null;
        }
        catch (XMLSemanticError e) {
            throw new IllegalArgumentException("Invalid stanza", e);
        }
    }

    public History(XMLElement elm) {
        super("http://jabber.org/protocol/muc", ELEMENT_HISTORY, null, elm.getAttributes(), null);
    }

    public History(Integer maxstanzas, Integer maxchars, Integer seconds, Calendar since) {
        super("http://jabber.org/protocol/muc", ELEMENT_HISTORY, null, History.createAttributes(maxstanzas, maxchars, seconds, since), null);
    }

    private static List<Attribute> createAttributes(Integer maxstanzas, Integer maxchars, Integer seconds, Calendar since) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        if (maxstanzas != null) {
            attributes.add(new Attribute(ATTRIBUTE_MAXSTANZAS, maxstanzas.toString()));
        }
        if (maxchars != null) {
            attributes.add(new Attribute(ATTRIBUTE_MAXCHARS, maxchars.toString()));
        }
        if (seconds != null) {
            attributes.add(new Attribute(ATTRIBUTE_SECONDS, seconds.toString()));
        }
        if (since != null) {
            attributes.add(new Attribute(ATTRIBUTE_SINCE, DateTimeProfile.getInstance().getDateTimeInUTC(since.getTime())));
        }
        return attributes;
    }

    private Integer getAttributeIntValue(String name) {
        String value = this.getAttributeValue(name);
        if (value != null && value.trim().length() > 0) {
            return Integer.valueOf(value);
        }
        return null;
    }

    public Integer getMaxStanzas() {
        return this.getAttributeIntValue(ATTRIBUTE_MAXSTANZAS);
    }

    public Integer getMaxChars() {
        return this.getAttributeIntValue(ATTRIBUTE_MAXCHARS);
    }

    public Integer getSeconds() {
        return this.getAttributeIntValue(ATTRIBUTE_SECONDS);
    }

    public Calendar getSince() {
        String value = this.getAttributeValue(ATTRIBUTE_SINCE);
        if (value != null) {
            Calendar timestamp = DateTimeProfile.getInstance().fromDateTime(value);
            return timestamp;
        }
        return null;
    }
}

