/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.compound.factories;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.compound.CompoundStore;
import net.sf.ehcache.store.compound.ElementSubstitute;
import net.sf.ehcache.store.compound.ElementSubstituteFilter;
import net.sf.ehcache.store.compound.IdentityElementSubstituteFactory;
import net.sf.ehcache.store.compound.factories.DiskOverflowStorageFactory;

public class CapacityLimitedInMemoryFactory
implements IdentityElementSubstituteFactory {
    private static final int MAX_EVICT = 5;
    private static final int SAMPLE_SIZE = 30;
    private final AtomicInteger count = new AtomicInteger();
    private final DiskOverflowStorageFactory secondary;
    private final RegisteredEventListeners eventService;
    private final ElementSubstituteFilter<Element> filter = new ElementSubstituteFilter<Element>(){

        @Override
        public boolean allows(Object object) {
            return CapacityLimitedInMemoryFactory.this.created(object);
        }
    };
    private volatile CompoundStore boundStore;
    private volatile int capacity;
    private volatile Policy policy;

    public CapacityLimitedInMemoryFactory(DiskOverflowStorageFactory secondary, int capacity, Policy policy, RegisteredEventListeners eventService) {
        this.secondary = secondary;
        if (secondary != null) {
            this.secondary.primary(this);
        }
        this.capacity = capacity;
        this.policy = policy;
        this.eventService = eventService;
    }

    public void bind(CompoundStore store) {
        this.boundStore = store;
        if (this.secondary != null) {
            this.secondary.bind(store);
        }
    }

    public void unbind(CompoundStore store) {
        if (this.secondary != null) {
            this.secondary.unbind(store);
        }
    }

    public Element create(Object key, Element element) {
        int overflow;
        int size = this.count.incrementAndGet();
        if (this.capacity > 0 && (overflow = size - this.capacity) > 0) {
            this.evict(Math.min(5, overflow), key, size);
        }
        return element;
    }

    private void evict(int n, Object keyHint, int size) {
        for (int i = 0; i < n; ++i) {
            Element target = this.getEvictionTarget(keyHint, size);
            if (target == null) continue;
            if (target.isExpired()) {
                if (!this.boundStore.evict(target.getObjectKey(), target)) continue;
                this.eventService.notifyElementExpiry(target, false);
                continue;
            }
            if (this.secondary == null) {
                if (!this.boundStore.evict(target.getObjectKey(), target)) continue;
                this.eventService.notifyElementEvicted(target, false);
                continue;
            }
            try {
                ElementSubstitute substitute = this.secondary.create(target.getObjectKey(), target);
                this.boundStore.fault(target.getObjectKey(), target, substitute);
                continue;
            }
            catch (IllegalArgumentException e) {
                if (!this.boundStore.evict(target.getObjectKey(), target)) continue;
                this.eventService.notifyElementEvicted(target, false);
            }
        }
    }

    private Element getEvictionTarget(Object keyHint, int size) {
        List<Element> sample = this.boundStore.getRandomSample(this.filter, Math.min(30, size), keyHint);
        return this.policy.selectedBasedOnPolicy(sample.toArray(new Element[sample.size()]), null);
    }

    public Element retrieve(Object key, Element object) {
        return object;
    }

    public void free(Lock exclusion, Element object) {
        this.count.decrementAndGet();
    }

    public int getSize() {
        return this.count.get();
    }

    public long getSizeInBytes() {
        long size = 0L;
        for (Object o : this.boundStore.getKeyArray()) {
            Object e = this.boundStore.unretrievedGet(o);
            if (!this.created(e)) continue;
            size += ((Element)e).getSerializedSize();
        }
        return size;
    }

    public Policy getEvictionPolicy() {
        return this.policy;
    }

    public void setEvictionPolicy(Policy policy) {
        this.policy = policy;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public boolean created(Object object) {
        return object instanceof Element;
    }

    public void expireElements() {
        for (Object key : this.boundStore.keySet()) {
            Element e;
            Object value = this.boundStore.unretrievedGet(key);
            if (!(value instanceof Element) || !(e = (Element)value).isExpired() || !this.boundStore.evict(key, value)) continue;
            this.eventService.notifyElementExpiry(e, false);
        }
    }
}

