/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction.xa;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.xa.Xid;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.transaction.TransactionContext;
import net.sf.ehcache.transaction.xa.EhcacheXAException;
import net.sf.ehcache.transaction.xa.EhcacheXAStore;
import net.sf.ehcache.transaction.xa.PreparedContext;
import net.sf.ehcache.transaction.xa.PreparedContextImpl;
import net.sf.ehcache.transaction.xa.VersionAwareCommand;
import net.sf.ehcache.transaction.xa.XATransactionContext;

public class EhcacheXAStoreImpl
implements EhcacheXAStore {
    protected final ConcurrentMap<Xid, XATransactionContext> transactionContextXids = new ConcurrentHashMap<Xid, XATransactionContext>();
    protected final ConcurrentMap<Xid, PreparedContext> prepareXids = new ConcurrentHashMap<Xid, PreparedContext>();
    protected final VersionTable versionTable = new VersionTable();
    protected Store underlyingStore;
    protected Store oldVersionStore;
    private final boolean bypassValidation;

    public EhcacheXAStoreImpl(Store underlyingStore, Store oldVersionStore, boolean bypassValidation) {
        this.underlyingStore = underlyingStore;
        this.oldVersionStore = oldVersionStore;
        this.bypassValidation = bypassValidation;
    }

    public Store getOldVersionStore() {
        return this.oldVersionStore;
    }

    public boolean isPrepared(Xid xid) {
        return this.prepareXids.containsKey(xid);
    }

    public void removeData(Xid xid) {
        this.prepareXids.remove(xid);
        this.transactionContextXids.remove(xid);
    }

    public boolean isBypassingValidation() {
        return this.bypassValidation;
    }

    public void checkin(Object key, Xid xid, boolean readOnly) {
        this.versionTable.checkin(key, xid, readOnly);
    }

    public long checkout(Object key, Xid xid) {
        return this.versionTable.checkout(key, xid);
    }

    public TransactionContext createTransactionContext(Xid xid) {
        XATransactionContext context = new XATransactionContext(xid, this);
        XATransactionContext previous = this.transactionContextXids.putIfAbsent(xid, context);
        if (previous != null) {
            context = previous;
        }
        return context;
    }

    public Xid[] getPreparedXids() {
        Set xidSet = this.prepareXids.keySet();
        return xidSet.toArray(new Xid[0]);
    }

    public TransactionContext getTransactionContext(Xid xid) {
        return (TransactionContext)this.transactionContextXids.get(xid);
    }

    public boolean isValid(VersionAwareCommand command, Xid xid) {
        return this.versionTable.valid(command.getKey(), command.getVersion());
    }

    public void prepare(Xid xid, PreparedContext context) throws EhcacheXAException {
        if (this.prepareXids.putIfAbsent(xid, context) != null) {
            throw new EhcacheXAException("A prepared context for that Xid already exists", -5);
        }
    }

    public PreparedContext getPreparedContext(Xid xid) {
        return (PreparedContext)this.prepareXids.get(xid);
    }

    public PreparedContext createPreparedContext() {
        return new PreparedContextImpl();
    }

    public Store getUnderlyingStore() {
        return this.underlyingStore;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Version {
        private final AtomicLong version = new AtomicLong(0L);
        private final ConcurrentMap<Xid, Long> txnVersions = new ConcurrentHashMap<Xid, Long>();

        public long getVersion() {
            return this.version.get();
        }

        public boolean hasTransaction(Xid xid) {
            return this.txnVersions.containsKey(xid);
        }

        public long getVersion(Xid xid) {
            try {
                return (Long)this.txnVersions.get(xid);
            }
            catch (NullPointerException e) {
                throw new AssertionError((Object)("Cannot get version for not existing transaction: " + xid));
            }
        }

        public long checkout(Xid xid) {
            long v = this.version.get();
            this.txnVersions.put(xid, v);
            return v;
        }

        public boolean checkinRead(Xid xid) {
            this.txnVersions.remove(xid);
            return this.txnVersions.isEmpty();
        }

        public boolean checkinWrite(Xid xid) {
            long v = (Long)this.txnVersions.remove(xid);
            this.version.incrementAndGet();
            return this.txnVersions.isEmpty();
        }

        ConcurrentMap<Xid, Long> getTxnVersions() {
            return this.txnVersions;
        }
    }

    public static class VersionTable {
        protected final ConcurrentMap<Object, Version> versionStore = new ConcurrentHashMap<Object, Version>();

        public boolean valid(Object key, long currentVersionNumber) {
            Version version = (Version)this.versionStore.get(key);
            if (version != null) {
                long currentVersion = version.getVersion();
                return currentVersion == currentVersionNumber;
            }
            throw new RuntimeException("No version checked out for this element, this is... WRONG!");
        }

        public long checkout(Object key, Xid xid) {
            Version version = (Version)this.versionStore.get(key);
            if (version == null) {
                version = new Version();
                this.versionStore.put(key, version);
            }
            long versionNumber = version.checkout(xid);
            return versionNumber;
        }

        public void checkin(Object key, Xid xid, boolean readOnly) {
            if (key != null) {
                Version version = (Version)this.versionStore.get(key);
                boolean removeEntry = readOnly ? version.checkinRead(xid) : version.checkinWrite(xid);
                if (removeEntry) {
                    this.versionStore.remove(key);
                }
            }
        }
    }
}

