/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.handler;

import java.util.Collections;
import java.util.List;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.NodeSubscriberVisitor;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.PubSubServiceConfiguration;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.SubscriptionItem;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.handler.AbstractPubSubGeneralHandler;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.handler.SubscriberSubscriptionVisitor;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.model.CollectionNode;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.model.LeafNode;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.stanza.IQStanza;
import org.apache.vysper.xmpp.stanza.IQStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.apache.vysper.xmpp.stanza.XMPPCoreStanza;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PubSubRetrieveSubscriptionsHandler
extends AbstractPubSubGeneralHandler {
    public PubSubRetrieveSubscriptionsHandler(PubSubServiceConfiguration serviceConfiguration) {
        super(serviceConfiguration);
    }

    @Override
    protected String getWorkerElement() {
        return "subscriptions";
    }

    protected Stanza handleGet(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        Entity serverJID = this.serviceConfiguration.getDomainJID();
        CollectionNode root = this.serviceConfiguration.getRootNode();
        Entity sender = PubSubRetrieveSubscriptionsHandler.extractSenderJID((XMPPCoreStanza)stanza, (SessionContext)sessionContext);
        String iqStanzaID = stanza.getAttributeValue("id");
        StanzaBuilder sb = StanzaBuilder.createDirectReply((XMPPCoreStanza)stanza, (boolean)false, (IQStanzaType)IQStanzaType.RESULT);
        sb.startInnerElement("pubsub", "http://jabber.org/protocol/pubsub");
        String nodeName = this.extractNodeName(stanza);
        List<SubscriptionItem> subscriptions = this.collectSubscriptions(root, sender, nodeName);
        this.buildSuccessStanza(sb, nodeName, subscriptions);
        sb.endInnerElement();
        return new IQStanza((Stanza)sb.build());
    }

    private List<SubscriptionItem> collectSubscriptions(CollectionNode root, Entity sender, String nodeName) {
        List<SubscriptionItem> subscriptions;
        if (nodeName == null) {
            NodeSubscriberVisitor nodeSubscriptionVisitor = new NodeSubscriberVisitor(sender);
            root.acceptNodes(nodeSubscriptionVisitor);
            subscriptions = nodeSubscriptionVisitor.getSubscriptions();
        } else {
            LeafNode node = root.find(nodeName);
            if (node == null) {
                subscriptions = Collections.emptyList();
            } else {
                SubscriberSubscriptionVisitor subscriptionVisitor = new SubscriberSubscriptionVisitor(sender);
                node.acceptSubscribers(subscriptionVisitor);
                subscriptions = subscriptionVisitor.getSubscriptions();
            }
        }
        return subscriptions;
    }

    private void buildSuccessStanza(StanzaBuilder sb, String nodeName, List<SubscriptionItem> subscriptions) {
        sb.startInnerElement("subscriptions", "http://jabber.org/protocol/pubsub");
        for (SubscriptionItem s : subscriptions) {
            sb.startInnerElement("subscription", "http://jabber.org/protocol/pubsub");
            sb.addAttribute("node", s.getNodeName());
            sb.addAttribute("jid", s.getSubscriberJID().getFullQualifiedName());
            sb.addAttribute("subscription", s.getSubscriptionState());
            sb.addAttribute("subid", s.getSubscriptionID());
            sb.endInnerElement();
        }
        sb.endInnerElement();
    }
}

