/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.delivery.StanzaRelay;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.ItemVisitor;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.MemberAffiliationVisitor;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.PubSubAffiliation;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.PubSubServiceConfiguration;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.SubscriberPayloadNotificationVisitor;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.SubscriberVisitor;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.feature.PubsubFeatures;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.model.LastOwnerResignedException;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.model.MultipleSubscriptionException;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.storageprovider.LeafNodeStorageProvider;
import org.apache.vysper.xmpp.modules.servicediscovery.management.Feature;
import org.apache.vysper.xmpp.modules.servicediscovery.management.Identity;
import org.apache.vysper.xmpp.modules.servicediscovery.management.InfoElement;
import org.apache.vysper.xmpp.modules.servicediscovery.management.InfoRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeafNode {
    protected String title;
    protected String name;
    protected LeafNodeStorageProvider storage = null;
    protected PubSubServiceConfiguration serviceConfiguration = null;

    public LeafNode(PubSubServiceConfiguration serviceConfiguration, String name, String title, Entity creator) {
        this.init(serviceConfiguration, name, title, creator);
    }

    public LeafNode(PubSubServiceConfiguration serviceConfiguration, String name, Entity creator) {
        this.init(serviceConfiguration, name, null, creator);
    }

    private void init(PubSubServiceConfiguration serviceConfiguration, String name, String title, Entity creator) {
        this.serviceConfiguration = serviceConfiguration;
        this.name = name;
        this.title = title;
        this.storage = serviceConfiguration.getLeafNodeStorageProvider();
        this.storage.initialize(this);
        try {
            this.setAffiliation(creator, PubSubAffiliation.OWNER);
        }
        catch (LastOwnerResignedException e) {
            // empty catch block
        }
    }

    public void setPersistenceManager(LeafNodeStorageProvider persistenceManager) {
        this.storage = persistenceManager;
    }

    public void subscribe(String id, Entity subscriber) {
        this.storage.addSubscriber(this.name, id, subscriber);
    }

    public boolean isSubscribed(Entity subscriber) {
        return this.storage.containsSubscriber(this.name, subscriber);
    }

    public boolean isSubscribed(String subscriptionID) {
        return this.storage.containsSubscriber(this.name, subscriptionID);
    }

    public boolean unsubscribe(String subscriptionID, Entity subscriber) {
        Entity sub = this.storage.getSubscriber(this.name, subscriptionID);
        if (sub != null && sub.equals(subscriber)) {
            return this.storage.removeSubscription(this.name, subscriptionID);
        }
        return false;
    }

    public boolean unsubscribe(Entity subscriber) throws MultipleSubscriptionException {
        if (this.countSubscriptions(subscriber) > 1) {
            throw new MultipleSubscriptionException("Ambigous unsubscription request");
        }
        return this.storage.removeSubscriber(this.name, subscriber);
    }

    public int countSubscriptions(Entity subscriber) {
        return this.storage.countSubscriptions(this.name, subscriber);
    }

    public int countSubscriptions() {
        return this.storage.countSubscriptions(this.name);
    }

    public void publish(Entity sender, StanzaRelay relay, String itemID, XMLElement item) {
        this.storage.addMessage(sender, this.name, itemID, item);
        this.sendMessageToSubscriber(relay, item);
    }

    protected void sendMessageToSubscriber(StanzaRelay stanzaRelay, XMLElement item) {
        this.storage.acceptForEachSubscriber(this.name, new SubscriberPayloadNotificationVisitor(this.serviceConfiguration.getDomainJID(), stanzaRelay, item));
    }

    public void acceptSubscribers(SubscriberVisitor sv) {
        this.storage.acceptForEachSubscriber(this.name, sv);
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public List<InfoElement> getNodeInfosFor(InfoRequest request) {
        ArrayList<InfoElement> infoElements = new ArrayList<InfoElement>();
        infoElements.add((InfoElement)new Identity("pubsub", "leaf"));
        infoElements.add((InfoElement)new Feature("http://jabber.org/protocol/pubsub"));
        infoElements.add((InfoElement)PubsubFeatures.ACCESS_OPEN.getFeature());
        infoElements.add((InfoElement)PubsubFeatures.ITEM_IDS.getFeature());
        infoElements.add((InfoElement)PubsubFeatures.PERSISTENT_ITEMS.getFeature());
        infoElements.add((InfoElement)PubsubFeatures.MULTI_SUBSCRIBE.getFeature());
        infoElements.add((InfoElement)PubsubFeatures.PUBLISH.getFeature());
        infoElements.add((InfoElement)PubsubFeatures.SUBSCRIBE.getFeature());
        infoElements.add((InfoElement)PubsubFeatures.RETRIEVE_SUBSCRIPTIONS.getFeature());
        infoElements.add((InfoElement)PubsubFeatures.RETRIEVE_AFFILIATIONS.getFeature());
        infoElements.add((InfoElement)PubsubFeatures.MODIFY_AFFILIATIONS.getFeature());
        return infoElements;
    }

    public void acceptItems(ItemVisitor iv) {
        this.storage.acceptForEachItem(this.name, iv);
    }

    public void acceptMemberAffiliations(MemberAffiliationVisitor mav) {
        this.storage.acceptForEachMemberAffiliation(this.name, mav);
    }

    public void initialize() {
        this.storage.initialize(this);
    }

    public void delete() {
        this.storage.delete(this.name);
    }

    public void setAffiliation(Entity owner, PubSubAffiliation affiliation) throws LastOwnerResignedException {
        this.storage.setAffiliation(this.name, owner, affiliation);
    }

    public boolean isAuthorized(Entity sender, PubSubAffiliation requestedAffiliation) {
        PubSubAffiliation affiliation = this.storage.getAffiliation(this.name, sender);
        return affiliation.compareTo(requestedAffiliation) >= 0;
    }

    public PubSubAffiliation getAffiliation(Entity entity) {
        return this.storage.getAffiliation(this.name, entity);
    }
}

