/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.common.filespecification;

import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSStream;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.pdfbox.pdmodel.common.filespecification.PDFileSpecification;

public class PDComplexFileSpecification
extends PDFileSpecification {
    private COSDictionary fs;

    public PDComplexFileSpecification() {
        this.fs = new COSDictionary();
        this.fs.setName("Type", "Filespec");
    }

    public PDComplexFileSpecification(COSDictionary dict) {
        this.fs = dict;
    }

    public COSBase getCOSObject() {
        return this.fs;
    }

    public COSDictionary getCOSDictionary() {
        return this.fs;
    }

    public String getFile() {
        return this.fs.getString("F");
    }

    public void setFile(String file) {
        this.fs.setString("F", file);
    }

    public String getFileDos() {
        return this.fs.getString("DOS");
    }

    public void setFileDos(String file) {
        this.fs.setString("DOS", file);
    }

    public String getFileMac() {
        return this.fs.getString("Mac");
    }

    public void setFileMac(String file) {
        this.fs.setString("Mac", file);
    }

    public String getFileUnix() {
        return this.fs.getString("Unix");
    }

    public void setFileUnix(String file) {
        this.fs.setString("Unix", file);
    }

    public void setVolatile(boolean fileIsVolatile) {
        this.fs.setBoolean("V", fileIsVolatile);
    }

    public boolean isVolatile() {
        return this.fs.getBoolean("V", false);
    }

    public PDEmbeddedFile getEmbeddedFile() {
        PDEmbeddedFile file = null;
        COSStream stream = (COSStream)this.fs.getObjectFromPath("EF/F");
        if (stream != null) {
            file = new PDEmbeddedFile(stream);
        }
        return file;
    }

    public void setEmbeddedFile(PDEmbeddedFile file) {
        COSDictionary ef = (COSDictionary)this.fs.getDictionaryObject("EF");
        if (ef == null && file != null) {
            ef = new COSDictionary();
            this.fs.setItem("EF", (COSBase)ef);
        }
        if (ef != null) {
            ef.setItem("F", (COSObjectable)file);
        }
    }

    public PDEmbeddedFile getEmbeddedFileDos() {
        PDEmbeddedFile file = null;
        COSStream stream = (COSStream)this.fs.getObjectFromPath("EF/DOS");
        if (stream != null) {
            file = new PDEmbeddedFile(stream);
        }
        return file;
    }

    public void setEmbeddedFileDos(PDEmbeddedFile file) {
        COSDictionary ef = (COSDictionary)this.fs.getDictionaryObject("DOS");
        if (ef == null && file != null) {
            ef = new COSDictionary();
            this.fs.setItem("EF", (COSBase)ef);
        }
        if (ef != null) {
            ef.setItem("DOS", (COSObjectable)file);
        }
    }

    public PDEmbeddedFile getEmbeddedFileMac() {
        PDEmbeddedFile file = null;
        COSStream stream = (COSStream)this.fs.getObjectFromPath("EF/Mac");
        if (stream != null) {
            file = new PDEmbeddedFile(stream);
        }
        return file;
    }

    public void setEmbeddedFileMac(PDEmbeddedFile file) {
        COSDictionary ef = (COSDictionary)this.fs.getDictionaryObject("Mac");
        if (ef == null && file != null) {
            ef = new COSDictionary();
            this.fs.setItem("EF", (COSBase)ef);
        }
        if (ef != null) {
            ef.setItem("Mac", (COSObjectable)file);
        }
    }

    public PDEmbeddedFile getEmbeddedFileUnix() {
        PDEmbeddedFile file = null;
        COSStream stream = (COSStream)this.fs.getObjectFromPath("EF/Unix");
        if (stream != null) {
            file = new PDEmbeddedFile(stream);
        }
        return file;
    }

    public void setEmbeddedFileUnix(PDEmbeddedFile file) {
        COSDictionary ef = (COSDictionary)this.fs.getDictionaryObject("Unix");
        if (ef == null && file != null) {
            ef = new COSDictionary();
            this.fs.setItem("EF", (COSBase)ef);
        }
        if (ef != null) {
            ef.setItem("Unix", (COSObjectable)file);
        }
    }
}

