/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.util.operator.pagedrawer;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSStream;
import org.pdfbox.pdfviewer.PageDrawer;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.PDResources;
import org.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.pdfbox.pdmodel.graphics.xobject.PDXObjectForm;
import org.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;
import org.pdfbox.util.Matrix;
import org.pdfbox.util.PDFOperator;
import org.pdfbox.util.operator.OperatorProcessor;

public class Invoke
extends OperatorProcessor {
    public void process(PDFOperator operator, List arguments) throws IOException {
        PageDrawer drawer = (PageDrawer)this.context;
        PDPage page = drawer.getPage();
        Dimension pageSize = drawer.getPageSize();
        Graphics2D graphics = drawer.getGraphics();
        COSName objectName = (COSName)arguments.get(0);
        Map xobjects = drawer.getResources().getXObjects();
        PDXObject xobject = (PDXObject)xobjects.get(objectName.getName());
        if (xobject instanceof PDXObjectImage) {
            PDXObjectImage image = (PDXObjectImage)xobject;
            try {
                BufferedImage awtImage = image.getRGBImage();
                Matrix ctm = drawer.getGraphicsState().getCurrentTransformationMatrix();
                int width = awtImage.getWidth();
                int height = awtImage.getHeight();
                double rotationInRadians = (double)page.findRotation() * Math.PI / 180.0;
                AffineTransform rotation = new AffineTransform();
                rotation.setToRotation(rotationInRadians);
                AffineTransform rotationInverse = rotation.createInverse();
                Matrix rotationInverseMatrix = new Matrix();
                rotationInverseMatrix.setFromAffineTransform(rotationInverse);
                Matrix rotationMatrix = new Matrix();
                rotationMatrix.setFromAffineTransform(rotation);
                Matrix unrotatedCTM = ctm.multiply(rotationInverseMatrix);
                Matrix scalingParams = unrotatedCTM.extractScaling();
                Matrix scalingMatrix = Matrix.getScaleInstance(1.0f / (float)width, 1.0f / (float)height);
                scalingParams = scalingParams.multiply(scalingMatrix);
                Matrix translationParams = unrotatedCTM.extractTranslating();
                Matrix translationMatrix = null;
                int pageRotation = page.findRotation();
                if (pageRotation == 0) {
                    translationParams.setValue(2, 1, -translationParams.getValue(2, 1));
                    translationMatrix = Matrix.getTranslatingInstance(0.0f, (float)pageSize.getHeight() - (float)height * scalingParams.getYScale());
                } else if (pageRotation == 90) {
                    translationMatrix = Matrix.getTranslatingInstance(0.0f, (float)pageSize.getHeight());
                }
                translationParams = translationParams.multiply(translationMatrix);
                AffineTransform at = new AffineTransform(scalingParams.getValue(0, 0), 0.0f, 0.0f, scalingParams.getValue(1, 1), translationParams.getValue(2, 0), translationParams.getValue(2, 1));
                graphics.drawImage(awtImage, at, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (xobject instanceof PDXObjectForm) {
            PDXObjectForm form = (PDXObjectForm)xobject;
            COSStream invoke = (COSStream)form.getCOSObject();
            PDResources pdResources = form.getResources();
            if (pdResources == null) {
                pdResources = page.findResources();
            }
            this.getContext().processSubStream(page, pdResources, invoke);
        }
    }
}

