/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import javax.faces.FacesException;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.PhaseId;
import javax.faces.render.ClientBehaviorRenderer;
import org.apache.myfaces.shared.renderkit.html.util.SharedStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlAjaxBehaviorRenderer
extends ClientBehaviorRenderer {
    private static final String QUOTE = "'";
    private static final String BLANK = " ";
    private static final String AJAX_KEY_ONERROR = "onerror";
    private static final String AJAX_KEY_ONEVENT = "onevent";
    private static final String AJAX_KEY_EXECUTE = "execute";
    private static final String AJAX_KEY_RENDER = "render";
    private static final String AJAX_VAL_THIS = "this";
    private static final String AJAX_VAL_EVENT = "event";
    private static final String JS_AJAX_REQUEST = "jsf.ajax.request";
    private static final String COLON = ":";
    private static final String EMPTY = "";
    private static final String COMMA = ",";
    private static final String ERR_NO_AJAX_BEHAVIOR = "The behavior must be an instance of AjaxBehavior";
    private static final String L_PAREN = "(";
    private static final String R_PAREN = ")";
    private static final String BEHAVIOR_EVENT = "javax.faces.behavior.event";
    private static final String IDENTIFYER_MARKER = "@";
    private static final String AJAX_SB = "oam.renderkit.AJAX_SB";
    private static final String AJAX_PARAM_SB = "oam.renderkit.AJAX_PARAM_SB";

    @Override
    public void decode(FacesContext context, UIComponent component, ClientBehavior behavior) {
        this.assertBehavior(behavior);
        AjaxBehavior ajaxBehavior = (AjaxBehavior)behavior;
        if (ajaxBehavior.isDisabled() || !component.isRendered()) {
            return;
        }
        this.dispatchBehaviorEvent(component, ajaxBehavior);
    }

    @Override
    public String getScript(ClientBehaviorContext behaviorContext, ClientBehavior behavior) {
        this.assertBehavior(behavior);
        AjaxBehavior ajaxBehavior = (AjaxBehavior)behavior;
        if (ajaxBehavior.isDisabled()) {
            return null;
        }
        return this.makeAjax(behaviorContext, ajaxBehavior).toString();
    }

    private final void dispatchBehaviorEvent(UIComponent component, AjaxBehavior ajaxBehavior) {
        AjaxBehaviorEvent event = new AjaxBehaviorEvent(component, ajaxBehavior);
        boolean isImmediate = false;
        isImmediate = ajaxBehavior.isImmediateSet() ? ajaxBehavior.isImmediate() : this.isComponentImmediate(component);
        PhaseId phaseId = isImmediate ? PhaseId.APPLY_REQUEST_VALUES : PhaseId.INVOKE_APPLICATION;
        event.setPhaseId(phaseId);
        component.queueEvent(event);
    }

    private final boolean isComponentImmediate(UIComponent component) {
        boolean isImmediate = false;
        if (component instanceof EditableValueHolder) {
            isImmediate = ((EditableValueHolder)((Object)component)).isImmediate();
        } else if (component instanceof ActionSource) {
            isImmediate = ((ActionSource)((Object)component)).isImmediate();
        }
        return isImmediate;
    }

    private final StringBuilder makeAjax(ClientBehaviorContext context, AjaxBehavior behavior) {
        StringBuilder retVal = SharedStringBuilder.get(context.getFacesContext(), AJAX_SB, 60);
        StringBuilder paramBuffer = SharedStringBuilder.get(context.getFacesContext(), AJAX_PARAM_SB, 20);
        String executes = this.mapToString(context, paramBuffer, AJAX_KEY_EXECUTE, behavior.getExecute());
        String render = this.mapToString(context, paramBuffer, AJAX_KEY_RENDER, behavior.getRender());
        String onError = behavior.getOnerror();
        if (onError != null && !onError.trim().equals(EMPTY)) {
            paramBuffer.setLength(0);
            paramBuffer.append(AJAX_KEY_ONERROR);
            paramBuffer.append(COLON);
            paramBuffer.append(onError);
            onError = paramBuffer.toString();
        } else {
            onError = null;
        }
        String onEvent = behavior.getOnevent();
        if (onEvent != null && !onEvent.trim().equals(EMPTY)) {
            paramBuffer.setLength(0);
            paramBuffer.append(AJAX_KEY_ONEVENT);
            paramBuffer.append(COLON);
            paramBuffer.append(onEvent);
            onEvent = paramBuffer.toString();
        } else {
            onEvent = null;
        }
        String sourceId = null;
        if (context.getSourceId() == null) {
            sourceId = AJAX_VAL_THIS;
        } else {
            paramBuffer.setLength(0);
            paramBuffer.append('\'');
            paramBuffer.append(context.getSourceId());
            paramBuffer.append('\'');
            sourceId = paramBuffer.toString();
        }
        String event = context.getEventName();
        retVal.append(JS_AJAX_REQUEST);
        retVal.append(L_PAREN);
        retVal.append(sourceId);
        retVal.append(COMMA);
        retVal.append(AJAX_VAL_EVENT);
        retVal.append(COMMA);
        Collection<ClientBehaviorContext.Parameter> params = context.getParameters();
        int paramSize = params != null ? params.size() : 0;
        ArrayList<String> parameterList = new ArrayList<String>(paramSize + 2);
        if (executes != null) {
            parameterList.add(executes.toString());
        }
        if (render != null) {
            parameterList.add(render.toString());
        }
        if (onError != null) {
            parameterList.add(onError);
        }
        if (onEvent != null) {
            parameterList.add(onEvent);
        }
        if (paramSize > 0) {
            if (params instanceof RandomAccess) {
                List list = (List)params;
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    ClientBehaviorContext.Parameter param = (ClientBehaviorContext.Parameter)list.get(i);
                    this.append(paramBuffer, parameterList, param);
                }
            } else {
                for (ClientBehaviorContext.Parameter param : params) {
                    this.append(paramBuffer, parameterList, param);
                }
            }
        }
        paramBuffer.setLength(0);
        paramBuffer.append(QUOTE);
        paramBuffer.append(BEHAVIOR_EVENT);
        paramBuffer.append(QUOTE);
        paramBuffer.append(COLON);
        paramBuffer.append(QUOTE);
        paramBuffer.append(event);
        paramBuffer.append(QUOTE);
        parameterList.add(paramBuffer.toString());
        retVal.append((CharSequence)this.buildOptions(context.getFacesContext(), paramBuffer, parameterList));
        retVal.append(R_PAREN);
        return retVal;
    }

    private void append(StringBuilder paramBuffer, List<String> parameterList, ClientBehaviorContext.Parameter param) {
        paramBuffer.setLength(0);
        paramBuffer.append(QUOTE);
        paramBuffer.append(param.getName());
        paramBuffer.append(QUOTE);
        paramBuffer.append(COLON);
        paramBuffer.append(QUOTE);
        paramBuffer.append(param.getValue().toString());
        paramBuffer.append(QUOTE);
        parameterList.add(paramBuffer.toString());
    }

    private StringBuilder buildOptions(FacesContext facesContext, StringBuilder retVal, List<String> options) {
        retVal.setLength(0);
        retVal.append("{");
        boolean first = true;
        int size = options.size();
        for (int i = 0; i < size; ++i) {
            String option = options.get(i);
            if (option == null || option.trim().equals(EMPTY)) continue;
            if (!first) {
                retVal.append(COMMA);
            } else {
                first = false;
            }
            retVal.append(option);
        }
        retVal.append("}");
        return retVal;
    }

    private final String mapToString(ClientBehaviorContext context, StringBuilder retVal, String target, Collection<String> dataHolder) {
        int executeSize;
        retVal.setLength(0);
        if (dataHolder == null) {
            dataHolder = Collections.emptyList();
        }
        if ((executeSize = dataHolder.size()) > 0) {
            int cnt;
            retVal.append(target);
            retVal.append(COLON);
            retVal.append(QUOTE);
            if (dataHolder instanceof RandomAccess) {
                List list = (List)dataHolder;
                for (cnt = 0; cnt < executeSize; ++cnt) {
                    String strVal = (String)list.get(cnt);
                    this.build(context, executeSize, retVal, cnt, strVal);
                }
            } else {
                for (String strVal : dataHolder) {
                    this.build(context, executeSize, retVal, ++cnt, strVal);
                }
            }
            retVal.append(QUOTE);
            return retVal.toString();
        }
        return null;
    }

    public void build(ClientBehaviorContext context, int size, StringBuilder retVal, int cnt, String strVal) {
        if (!EMPTY.equals(strVal = strVal.trim())) {
            if (!strVal.startsWith(IDENTIFYER_MARKER)) {
                String componentId = this.getComponentId(context, strVal);
                retVal.append(componentId);
            } else {
                retVal.append(strVal);
            }
            if (cnt < size) {
                retVal.append(BLANK);
            }
        }
    }

    private final String getComponentId(ClientBehaviorContext context, String id) {
        UIComponent contextComponent = context.getComponent();
        UIComponent target = contextComponent.findComponent(id);
        if (target == null) {
            target = contextComponent.findComponent(UINamingContainer.getSeparatorChar(context.getFacesContext()) + id);
        }
        if (target != null) {
            return target.getClientId(context.getFacesContext());
        }
        throw new FacesException("Component with id:" + id + " not found");
    }

    private final void assertBehavior(ClientBehavior behavior) {
        if (!(behavior instanceof AjaxBehavior)) {
            throw new FacesException(ERR_NO_AJAX_BEHAVIOR);
        }
    }
}

