/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.push.cdi;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessProducer;
import jakarta.enterprise.inject.spi.Producer;
import jakarta.faces.push.Push;
import jakarta.faces.push.PushContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.myfaces.push.cdi.PushContextFactoryBean;
import org.apache.myfaces.push.cdi.WebsocketApplicationBean;
import org.apache.myfaces.push.cdi.WebsocketChannelTokenBuilderBean;
import org.apache.myfaces.push.cdi.WebsocketSessionBean;
import org.apache.myfaces.push.cdi.WebsocketViewBean;

public class PushContextCDIExtension
implements Extension {
    private List<Producer<PushContext>> pushContextProducers = new ArrayList<Producer<PushContext>>();

    public List<Producer<PushContext>> getPushContextProducers() {
        return this.pushContextProducers;
    }

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        AnnotatedType pushContextFactoryBean = beanManager.createAnnotatedType(PushContextFactoryBean.class);
        event.addAnnotatedType(pushContextFactoryBean, pushContextFactoryBean.getJavaClass().getName());
        AnnotatedType wcbean = beanManager.createAnnotatedType(WebsocketChannelTokenBuilderBean.class);
        event.addAnnotatedType(wcbean, wcbean.getJavaClass().getName());
        AnnotatedType sessionhandlerbean = beanManager.createAnnotatedType(WebsocketSessionBean.class);
        event.addAnnotatedType(sessionhandlerbean, sessionhandlerbean.getJavaClass().getName());
        AnnotatedType viewTokenBean = beanManager.createAnnotatedType(WebsocketViewBean.class);
        event.addAnnotatedType(viewTokenBean, viewTokenBean.getJavaClass().getName());
        AnnotatedType apphandlerbean = beanManager.createAnnotatedType(WebsocketApplicationBean.class);
        event.addAnnotatedType(apphandlerbean, apphandlerbean.getJavaClass().getName());
    }

    <T> void findFlowDefinition(@Observes ProcessProducer<T, PushContext> processProducer) {
        if (processProducer.getAnnotatedMember().isAnnotationPresent(Push.class)) {
            this.pushContextProducers.add((Producer<PushContext>)processProducer.getProducer());
        }
    }
}

