/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi.impl;

import jakarta.faces.context.ExternalContext;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.spi.ServiceProviderFinderFactory;

public final class SpiUtils {
    public static Object build(ExternalContext ectx, Class spiClass, String defaultImpl) {
        List<String> classList = ServiceProviderFinderFactory.getServiceProviderFinder(ectx).getServiceProviderList(spiClass.getName());
        if (classList != null && !classList.isEmpty()) {
            if (classList.size() > 1) {
                SpiUtils.getLogger().log(Level.WARNING, "More than one SPI interface for " + spiClass.getName() + " found :" + classList.toString() + ". Setting up the first one found.");
            }
            return ClassUtils.newInstance(classList.get(0));
        }
        return ClassUtils.newInstance(defaultImpl);
    }

    private static Logger getLogger() {
        return Logger.getLogger(SpiUtils.class.getName());
    }
}

