/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.ee;

import jakarta.faces.application.ResourceDependencies;
import jakarta.faces.application.ResourceDependency;
import jakarta.faces.bean.ApplicationScoped;
import jakarta.faces.bean.CustomScoped;
import jakarta.faces.bean.ManagedBean;
import jakarta.faces.bean.ManagedProperty;
import jakarta.faces.bean.NoneScoped;
import jakarta.faces.bean.ReferencedBean;
import jakarta.faces.bean.RequestScoped;
import jakarta.faces.bean.SessionScoped;
import jakarta.faces.bean.ViewScoped;
import jakarta.faces.component.FacesComponent;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.behavior.FacesBehavior;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.FacesConverter;
import jakarta.faces.event.ListenerFor;
import jakarta.faces.event.ListenersFor;
import jakarta.faces.event.NamedEvent;
import jakarta.faces.model.FacesDataModel;
import jakarta.faces.render.FacesBehaviorRenderer;
import jakarta.faces.render.FacesRenderer;
import jakarta.faces.render.Renderer;
import jakarta.faces.validator.FacesValidator;
import jakarta.faces.validator.Validator;
import jakarta.faces.webapp.FacesServlet;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.annotation.HandlesTypes;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.context.servlet.StartupServletExternalContextImpl;
import org.apache.myfaces.shared_impl.webapp.webxml.DelegatedFacesServlet;
import org.apache.myfaces.spi.FacesConfigResourceProvider;
import org.apache.myfaces.spi.FacesConfigResourceProviderFactory;
import org.apache.myfaces.webapp.ManagedBeanDestroyerListener;

@HandlesTypes(value={ApplicationScoped.class, CustomScoped.class, FacesBehavior.class, FacesBehaviorRenderer.class, FacesComponent.class, FacesConverter.class, FacesRenderer.class, FacesValidator.class, FacesDataModel.class, ListenerFor.class, ListenersFor.class, ManagedBean.class, ManagedProperty.class, NamedEvent.class, NoneScoped.class, ReferencedBean.class, RequestScoped.class, ResourceDependencies.class, ResourceDependency.class, SessionScoped.class, ViewScoped.class, UIComponent.class, Converter.class, Renderer.class, Validator.class})
public class MyFacesContainerInitializer
implements ServletContainerInitializer {
    public static final String FACES_SERVLET_ADDED_ATTRIBUTE = "org.apache.myfaces.DYNAMICALLY_ADDED_FACES_SERVLET";
    public static final String FACES_SERVLET_FOUND = "org.apache.myfaces.FACES_SERVLET_FOUND";
    private static final String INITIALIZE_ALWAYS_STANDALONE = "org.apache.myfaces.INITIALIZE_ALWAYS_STANDALONE";
    private static final String INITIALIZE_SKIP_JAR_FACES_CONFIG_SCAN = "org.apache.myfaces.INITIALIZE_SKIP_JAR_FACES_CONFIG_SCAN";
    private static final String FACES_CONFIG_RESOURCE = "/WEB-INF/faces-config.xml";
    private static final Logger log = Logger.getLogger(MyFacesContainerInitializer.class.getName());
    private static final String[] FACES_SERVLET_MAPPINGS = new String[]{"/faces/*", "*.jsf", "*.faces"};
    private static final String[] FACES_SERVLET_FULL_MAPPINGS = new String[]{"/faces/*", "*.jsf", "*.faces", "*.xhtml"};
    private static final String FACES_SERVLET_NAME = "FacesServlet";
    private static final Class<? extends Servlet> FACES_SERVLET_CLASS = FacesServlet.class;
    private static final Class<?> DELEGATED_FACES_SERVLET_CLASS = DelegatedFacesServlet.class;

    public void onStartup(Set<Class<?>> clazzes, ServletContext servletContext) throws ServletException {
        boolean startDireclty;
        log.log(Level.INFO, "Using " + MyFacesContainerInitializer.class.getName());
        String supportManagedBeans = servletContext.getInitParameter("org.apache.myfaces.SUPPORT_MANAGED_BEANS");
        if (supportManagedBeans == null || Boolean.TRUE.toString().equals(supportManagedBeans)) {
            ManagedBeanDestroyerListener destroyListener = new ManagedBeanDestroyerListener();
            servletContext.addListener((EventListener)((Object)destroyListener));
            servletContext.setAttribute(ManagedBeanDestroyerListener.APPLICATION_MAP_KEY, (Object)destroyListener);
        }
        if (startDireclty = this.shouldStartupRegardless(servletContext)) {
            return;
        }
        if (clazzes != null && !clazzes.isEmpty() || this.isFacesConfigPresent(servletContext)) {
            Object[] mappings;
            Map servlets = servletContext.getServletRegistrations();
            for (Map.Entry servletEntry : servlets.entrySet()) {
                String className = ((ServletRegistration)servletEntry.getValue()).getClassName();
                if (!FACES_SERVLET_CLASS.getName().equals(className) && !this.isDelegatedFacesServlet(className)) continue;
                servletContext.setAttribute(FACES_SERVLET_FOUND, (Object)Boolean.TRUE);
                return;
            }
            ServletRegistration.Dynamic servlet = servletContext.addServlet(FACES_SERVLET_NAME, FACES_SERVLET_CLASS);
            Set conflictMappings = servlet.addMapping((String[])(mappings = this.isAutomaticXhtmlMappingDisabled(servletContext) ? FACES_SERVLET_MAPPINGS : FACES_SERVLET_FULL_MAPPINGS));
            if (conflictMappings != null && !conflictMappings.isEmpty()) {
                HashSet<String> newMappings = new HashSet<String>(Arrays.asList(mappings));
                newMappings.removeAll(conflictMappings);
                mappings = newMappings.toArray(new String[newMappings.size()]);
                servlet.addMapping((String[])mappings);
            }
            if (mappings != null && mappings.length > 0) {
                servletContext.setAttribute(FACES_SERVLET_ADDED_ATTRIBUTE, (Object)Boolean.TRUE);
                log.log(Level.INFO, "Added FacesServlet with mappings=" + Arrays.toString(mappings));
            }
        }
    }

    private boolean shouldStartupRegardless(ServletContext servletContext) {
        try {
            String standaloneStartup = servletContext.getInitParameter(INITIALIZE_ALWAYS_STANDALONE);
            return "true".equalsIgnoreCase(standaloneStartup);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean shouldSkipJarFacesConfigScan(ServletContext servletContext) {
        try {
            String skipJarScan = servletContext.getInitParameter(INITIALIZE_SKIP_JAR_FACES_CONFIG_SCAN);
            if (skipJarScan == null) {
                skipJarScan = System.getProperty(INITIALIZE_SKIP_JAR_FACES_CONFIG_SCAN);
            }
            return "true".equalsIgnoreCase(skipJarScan);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isAutomaticXhtmlMappingDisabled(ServletContext servletContext) {
        try {
            String xhtmlMappingDisabled = servletContext.getInitParameter("jakarta.faces.DISABLE_FACESSERVLET_TO_XHTML");
            if (xhtmlMappingDisabled == null) {
                xhtmlMappingDisabled = "false";
            }
            return "true".equalsIgnoreCase(xhtmlMappingDisabled);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isFacesConfigPresent(ServletContext servletContext) {
        try {
            StartupServletExternalContextImpl externalContext;
            FacesConfigResourceProviderFactory factory;
            FacesConfigResourceProvider provider;
            Collection<URL> metaInfFacesConfigUrls;
            if (servletContext.getResource(FACES_CONFIG_RESOURCE) != null) {
                return true;
            }
            String configFilesAttrValue = servletContext.getInitParameter("jakarta.faces.CONFIG_FILES");
            if (configFilesAttrValue != null) {
                String[] configFiles;
                for (String file : configFiles = configFilesAttrValue.split(",")) {
                    if (servletContext.getResource(file.trim()) == null) continue;
                    return true;
                }
            }
            return !this.shouldSkipJarFacesConfigScan(servletContext) && (metaInfFacesConfigUrls = (provider = (factory = FacesConfigResourceProviderFactory.getFacesConfigResourceProviderFactory(externalContext = new StartupServletExternalContextImpl(servletContext, true))).createFacesConfigResourceProvider(externalContext)).getMetaInfConfigurationResources(externalContext)) != null && !metaInfFacesConfigUrls.isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isDelegatedFacesServlet(String className) {
        if (className == null) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName(className);
            return DELEGATED_FACES_SERVLET_CLASS.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }
}

