/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context;

import jakarta.el.ELException;
import jakarta.faces.FacesException;
import jakarta.faces.context.ExceptionHandler;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.PartialResponseWriter;
import jakarta.faces.context.PartialViewContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ExceptionQueuedEvent;
import jakarta.faces.event.ExceptionQueuedEventContext;
import jakarta.faces.event.SystemEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.context.ExceptionHandlerUtils;
import org.apache.myfaces.core.api.shared.lang.Assert;

public class AjaxExceptionHandlerImpl
extends ExceptionHandler {
    private static final Logger log = Logger.getLogger(AjaxExceptionHandlerImpl.class.getName());
    private Queue<ExceptionQueuedEvent> handled;
    private Queue<ExceptionQueuedEvent> unhandled;
    private ExceptionQueuedEvent handledAndThrown;

    @Override
    public ExceptionQueuedEvent getHandledExceptionQueuedEvent() {
        return this.handledAndThrown;
    }

    @Override
    public Iterable<ExceptionQueuedEvent> getHandledExceptionQueuedEvents() {
        return this.handled == null ? Collections.emptyList() : this.handled;
    }

    @Override
    public Throwable getRootCause(Throwable throwable) {
        Assert.notNull(throwable, "throwable");
        while (throwable != null) {
            Class<?> clazz = throwable.getClass();
            if (!clazz.equals(FacesException.class) && !clazz.equals(ELException.class)) {
                return throwable;
            }
            throwable = throwable.getCause();
        }
        return null;
    }

    @Override
    public Iterable<ExceptionQueuedEvent> getUnhandledExceptionQueuedEvents() {
        return this.unhandled == null ? Collections.emptyList() : this.unhandled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle() throws FacesException {
        if (this.unhandled != null && !this.unhandled.isEmpty()) {
            if (this.handled == null) {
                this.handled = new LinkedList<ExceptionQueuedEvent>();
            }
            ArrayList<Throwable> throwableList = new ArrayList<Throwable>();
            FacesContext facesContext = null;
            do {
                ExceptionQueuedEvent event = this.unhandled.peek();
                try {
                    Throwable exception;
                    ExceptionQueuedEventContext context = event.getContext();
                    if (facesContext == null) {
                        facesContext = event.getContext().getContext();
                    }
                    if (this.shouldSkip(exception = context.getException())) continue;
                    Throwable rootCause = this.getRootCause(exception);
                    this.handledAndThrown = event;
                    throwableList.add(rootCause == null ? exception : rootCause);
                    ExceptionHandlerUtils.logException(rootCause == null ? exception : rootCause, context.getComponent(), context.getContext(), log);
                }
                finally {
                    this.handled.add(event);
                    this.unhandled.remove(event);
                }
            } while (!this.unhandled.isEmpty());
            if (!throwableList.isEmpty()) {
                PartialResponseWriter partialWriter = null;
                boolean responseComplete = false;
                if (facesContext == null) {
                    facesContext = FacesContext.getCurrentInstance();
                }
                facesContext = facesContext == null ? FacesContext.getCurrentInstance() : facesContext;
                ExternalContext externalContext = facesContext.getExternalContext();
                if (!facesContext.getExternalContext().isResponseCommitted()) {
                    facesContext.getExternalContext().responseReset();
                }
                PartialViewContext partialViewContext = facesContext.getPartialViewContext();
                partialWriter = partialViewContext.getPartialResponseWriter();
                externalContext.setResponseContentType("text/xml");
                externalContext.setResponseCharacterEncoding("UTF-8");
                externalContext.addResponseHeader("Cache-control", "no-cache");
                try {
                    partialWriter.startDocument();
                    for (Throwable t : throwableList) {
                        this.renderAjaxError(partialWriter, t);
                    }
                    responseComplete = true;
                }
                catch (IOException e) {
                    if (log.isLoggable(Level.SEVERE)) {
                        log.log(Level.SEVERE, "Cannot render exception on ajax request", e);
                    }
                }
                finally {
                    block25: {
                        if (responseComplete) {
                            try {
                                partialWriter.endDocument();
                                facesContext.responseComplete();
                            }
                            catch (IOException e1) {
                                if (!log.isLoggable(Level.SEVERE)) break block25;
                                log.log(Level.SEVERE, "Cannot render exception on ajax request", e1);
                            }
                        }
                    }
                }
            }
        }
    }

    private void renderAjaxError(PartialResponseWriter partialWriter, Throwable ex) throws IOException {
        partialWriter.startError(ex.getClass().getName());
        if (ex.getCause() != null) {
            partialWriter.write(ex.getCause().toString());
        } else if (ex.getMessage() != null) {
            partialWriter.write(ex.getMessage());
        }
        partialWriter.endError();
    }

    @Override
    public boolean isListenerForSource(Object source) {
        return source instanceof ExceptionQueuedEventContext;
    }

    @Override
    public void processEvent(SystemEvent exceptionQueuedEvent) throws AbortProcessingException {
        if (this.unhandled == null) {
            this.unhandled = new LinkedList<ExceptionQueuedEvent>();
        }
        this.unhandled.add((ExceptionQueuedEvent)exceptionQueuedEvent);
    }

    protected Throwable getRethrownException(Throwable exception) {
        Throwable toRethrow = this.getRootCause(exception);
        if (toRethrow == null) {
            toRethrow = exception;
        }
        return toRethrow;
    }

    protected FacesException wrap(Throwable exception) {
        if (exception instanceof FacesException) {
            return (FacesException)exception;
        }
        return new FacesException(exception);
    }

    protected boolean shouldSkip(Throwable exception) {
        return exception instanceof AbortProcessingException;
    }
}

