/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation;

import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.Conversation;
import org.apache.myfaces.extensions.cdi.core.api.security.AccessDecisionState;
import org.apache.myfaces.extensions.cdi.core.api.security.AccessDecisionVoterContext;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.ConversationAware;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.ConversationExpirationEvaluator;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.ConversationUtils;

class ViewAccessConversationExpirationEvaluator
implements ConversationExpirationEvaluator,
ConversationAware {
    private static final long serialVersionUID = 5586717766107967144L;
    private String lastViewId;
    private Conversation conversation;
    private AccessDecisionVoterContext accessDecisionVoterContext;

    ViewAccessConversationExpirationEvaluator(AccessDecisionVoterContext accessDecisionVoterContext) {
        this.accessDecisionVoterContext = accessDecisionVoterContext;
    }

    void observeRenderedView(String viewId) {
        if (viewId != null && !viewId.equals(this.lastViewId)) {
            if (this.conversation != null) {
                this.conversation.close();
            }
            this.expire();
        }
    }

    public boolean isExpired() {
        String currentViewId;
        if (this.accessDecisionVoterContext != null && AccessDecisionState.VOTE_IN_PROGRESS.equals((Object)this.accessDecisionVoterContext.getState())) {
            return false;
        }
        if (this.lastViewId == null) {
            return true;
        }
        String oldViewId = ConversationUtils.getOldViewId();
        if (oldViewId != null && oldViewId.equals(this.lastViewId)) {
            this.lastViewId = ConversationUtils.getNewViewId();
        }
        if ((currentViewId = this.getCurrentViewId()) == null) {
            return false;
        }
        boolean result = !currentViewId.equals(this.lastViewId);
        return result;
    }

    public void touch() {
        this.lastViewId = this.getCurrentViewId();
    }

    public void expire() {
        this.lastViewId = null;
        this.conversation = null;
    }

    private String getCurrentViewId() {
        return FacesContext.getCurrentInstance().getViewRoot().getViewId();
    }

    public void setConversation(Conversation conversation) {
        this.conversation = conversation;
    }
}

