/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.message;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.Typed;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.cdi.core.impl.util.UnmodifiableMap;
import org.apache.myfaces.extensions.cdi.jsf.impl.message.SimpleNamedArgument;
import org.apache.myfaces.extensions.cdi.message.api.Localizable;
import org.apache.myfaces.extensions.cdi.message.api.Message;
import org.apache.myfaces.extensions.cdi.message.api.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Typed
class MessageHelperMap
extends UnmodifiableMap<String, Object> {
    private static final long serialVersionUID = 2530702568624997067L;
    private MessageContext messageContext;
    private List<Serializable> numberedArgument = new ArrayList<Serializable>();
    private Map<String, Serializable> namedArgument = new HashMap<String, Serializable>();
    private String messageKey;

    MessageHelperMap(MessageContext messageContext) {
        this.messageContext = messageContext;
    }

    public Object get(Object arg) {
        String stringArgument;
        String[] keyValuePair;
        Object argument = arg instanceof Serializable ? (Serializable)arg : (arg instanceof Localizable ? ((Localizable)arg).toString(this.messageContext) : arg.toString());
        if ("toText".equals(argument)) {
            return this.getToText();
        }
        if ("toMessage".equals(argument)) {
            return this.getToMessage();
        }
        if (this.messageKey == null) {
            this.messageKey = "{" + argument + "}";
            return this;
        }
        String argumentKey = null;
        Object argumentValue = null;
        if (argument instanceof String && ((String)argument).contains(":") && (keyValuePair = (stringArgument = (String)argument).split(":")).length > 1) {
            String expression;
            String key = keyValuePair[0];
            if (!key.contains(" ")) {
                argumentKey = key;
            }
            if ((expression = (argumentValue = stringArgument.substring(stringArgument.indexOf(":") + 1)).toString().trim()).startsWith("#{") && expression.endsWith("}")) {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                argumentValue = facesContext.getApplication().evaluateExpressionGet(facesContext, expression, Object.class);
            }
        }
        if (argumentValue == null) {
            argumentValue = argument;
        }
        Object value = argumentValue instanceof Serializable ? (Serializable)argumentValue : (argumentValue instanceof Localizable ? ((Localizable)argumentValue).toString(this.messageContext) : (argumentValue != null ? argumentValue.toString() : null));
        if (argumentKey == null) {
            this.numberedArgument.add((Serializable)value);
        } else {
            this.namedArgument.put(argumentKey, (Serializable)value);
        }
        return this;
    }

    public Message getToMessage() {
        Message message = this.messageContext.message().text(this.messageKey).create();
        for (Serializable serializable : this.numberedArgument) {
            message.addArgument(new Serializable[]{serializable});
        }
        for (Map.Entry entry : this.namedArgument.entrySet()) {
            message.addArgument(new Serializable[]{new SimpleNamedArgument((String)entry.getKey(), (Serializable)entry.getValue())});
        }
        return message;
    }

    public String getToText() {
        Message message = this.getToMessage();
        return message.toString(this.messageContext);
    }
}

