/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.internal.component.AbstractUIPopover;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.html.CustomAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.sanitizer.SanitizeMode;
import org.apache.myfaces.tobago.sanitizer.Sanitizer;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class PopoverRenderer<T extends AbstractUIPopover>
extends RendererBase<T> {
    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = component.getClientId(facesContext);
        String labelString = ((AbstractUIPopover)component).getLabel();
        String currentValue = this.getCurrentValue(facesContext, component);
        this.insideBegin(facesContext, HtmlElements.TOBAGO_POPOVER);
        writer.startElement(HtmlElements.TOBAGO_POPOVER);
        writer.writeIdAttribute(clientId);
        if (component.getCustomClass() != null) {
            writer.writeAttribute(CustomAttributes.CUSTOM_CLASS, component.getCustomClass().getName(), true);
        }
        if (SanitizeMode.auto == ((AbstractUIPopover)component).getSanitize()) {
            Sanitizer sanitizer = TobagoConfig.getInstance(facesContext).getSanitizer();
            if (labelString != null && !labelString.isEmpty()) {
                writer.writeAttribute(CustomAttributes.LABEL, sanitizer.sanitize(labelString), true);
            }
            writer.writeAttribute(HtmlAttributes.VALUE, sanitizer.sanitize(currentValue), true);
        } else {
            if (labelString != null && !labelString.isEmpty()) {
                writer.writeAttribute(CustomAttributes.LABEL, labelString, true);
            }
            writer.writeAttribute(HtmlAttributes.VALUE, currentValue, true);
        }
        writer.writeAttribute(CustomAttributes.ESCAPE, Boolean.toString(((AbstractUIPopover)component).isEscape()), false);
        writer.writeAttribute(CustomAttributes.SANITIZE, ((AbstractUIPopover)component).getSanitize().name(), false);
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.TOBAGO_POPOVER);
        this.insideEnd(facesContext, HtmlElements.TOBAGO_POPOVER);
    }
}

