/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.webapp;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.tobago.internal.util.Deprecation;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;

public abstract class TobagoResponseWriter
extends ResponseWriter {
    @Deprecated
    public abstract void startElement(String var1, UIComponent var2) throws IOException;

    public abstract void startElement(HtmlElements var1) throws IOException;

    @Deprecated
    public abstract void endElement(String var1) throws IOException;

    public abstract void endElement(HtmlElements var1) throws IOException;

    public abstract void write(String var1) throws IOException;

    public abstract void writeComment(Object var1) throws IOException;

    public abstract ResponseWriter cloneWithWriter(Writer var1);

    @Deprecated
    public abstract void writeAttribute(String var1, Object var2, String var3) throws IOException;

    @Deprecated
    public abstract void writeURIAttribute(String var1, Object var2, String var3) throws IOException;

    @Deprecated
    public abstract void writeText(Object var1, String var2) throws IOException;

    public abstract void flush() throws IOException;

    public abstract void writeAttribute(MarkupLanguageAttributes var1, String var2, boolean var3) throws IOException;

    public abstract void writeAttribute(MarkupLanguageAttributes var1, HtmlTypes var2) throws IOException;

    public abstract void writeURIAttribute(MarkupLanguageAttributes var1, String var2) throws IOException;

    public void writeAttribute(MarkupLanguageAttributes name, boolean on) throws IOException {
        if (on) {
            this.writeAttribute(name, name.getValue(), false);
        }
    }

    public void writeAttribute(MarkupLanguageAttributes name, Integer number) throws IOException {
        if (number != null) {
            this.writeAttribute(name, Integer.toString(number), false);
        }
    }

    public void writeIdAttribute(String id) throws IOException {
        this.writeAttribute(HtmlAttributes.ID, id, false);
    }

    public void writeNameAttribute(String name) throws IOException {
        this.writeAttribute(HtmlAttributes.NAME, name, false);
    }

    @Deprecated
    public void writeCommandMapAttribute(String map) throws IOException {
        Deprecation.LOG.error("No longer supported. Data: {}", (Object)map);
    }

    public void writeClassAttribute(CssItem ... first) throws IOException {
        this.writeClassAttribute((CssItem)null, (CssItem[])null, (CssItem[])null, (CssItem[])null, (CssItem[])null, first);
    }

    public void writeClassAttribute(CssItem first, CssItem[] second, CssItem ... third) throws IOException {
        this.writeClassAttribute(first, second, (CssItem[])null, (CssItem[])null, (CssItem[])null, third);
    }

    public void writeClassAttribute(CssItem first, CssItem[] second, CssItem[] third, CssItem ... fourth) throws IOException {
        this.writeClassAttribute(first, second, third, (CssItem[])null, (CssItem[])null, fourth);
    }

    public void writeClassAttribute(CssItem first, CssItem[] second, CssItem[] third, CssItem[] fourth, CssItem ... fifth) throws IOException {
        this.writeClassAttribute(first, second, third, fourth, (CssItem[])null, fifth);
    }

    public void writeClassAttribute(CssItem first, CssItem[] second, CssItem[] third, CssItem[] fourth, CssItem[] fifth, CssItem ... sixth) throws IOException {
        StringBuilder builder = new StringBuilder();
        boolean render = false;
        if (first != null) {
            builder.append(first.getName());
            builder.append(' ');
            render = true;
        }
        if (second != null) {
            render |= this.writeCssItem(builder, second);
        }
        if (third != null) {
            render |= this.writeCssItem(builder, third);
        }
        if (fourth != null) {
            render |= this.writeCssItem(builder, fourth);
        }
        if (fifth != null) {
            render |= this.writeCssItem(builder, fifth);
        }
        if (sixth != null) {
            render |= this.writeCssItem(builder, sixth);
        }
        if (render) {
            this.writeAttribute(HtmlAttributes.CLASS, builder.deleteCharAt(builder.length() - 1).toString(), false);
        }
    }

    private boolean writeCssItem(StringBuilder builder, CssItem ... cssItems) {
        boolean render = false;
        for (CssItem cssItem : cssItems) {
            if (cssItem == null || "".equals(cssItem.getName())) continue;
            builder.append(cssItem.getName());
            builder.append(' ');
            render = true;
        }
        return render;
    }

    public void writeText(String text) throws IOException {
        this.writeText(text, null);
    }

    public String getContentTypeWithCharSet() {
        String characterEncoding;
        String contentType = this.getContentType();
        if (contentType == null) {
            contentType = "text/html";
        }
        if ((characterEncoding = this.getCharacterEncoding()) == null) {
            characterEncoding = StandardCharsets.UTF_8.name();
        }
        return contentType + "; charset=" + characterEncoding;
    }

    public void startCDATA() throws IOException {
        this.write("<![CDATA[");
    }

    public void endCDATA() throws IOException {
        this.write("]]>");
    }
}

