/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable
 * law or agreed to in writing, software distributed under the License is distributed on an "AS IS"
 * BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License
 * for the specific language governing permissions and limitations under the License.
 */
package javax.portlet.faces.event;


/**
 * An <code>EventNavigationResult</code> is the type of object that can
 * be returned from a <code>BrdigeEventHandler.handleEvent</code> call.
 * When it is returned (non-null) it conveys the Faces navigation information
 * to the bridge that it needs to utilize the Faces <code>NavigationHandler</code>
 * to evaluate the navigation according to the configured rules.  The
 * <code>fromAction</code> corresponds to the <code>fromAction</code> string
 * in the faces-config.xml navigation rule.  The <code>outcome</code> 
 * corresponds to the <code>outcome</code> string in the navigation rule.
 */

public class EventNavigationResult extends Object
{
    private String mFromAction;
    private String mOutcome;
   
  /**
   * Null constructor
   */    
    public EventNavigationResult()
    {
      
    }

  /**
   * Constructor which sets the object to the desired fromAction and outcome
   * 
   * @param action
   *       desired fromAction
   * @param outcome
   *       desired outcome
   */     
    public EventNavigationResult(String action, String outcome)
    {
      mFromAction = action;
      mOutcome = outcome;
    }
    
  /**
   * Gets the fromAction stored in this object. The <code>fromAction</code>
   * corresponds to the <code>fromAction</code> string in the faces-config.xml
   * navigation rule.
   * 
   * @return <code>String</code> containing the fromAction
   */
    public String getFromAction()
    {
      return mFromAction;
    }

  /**
   * Sets the fromAction for this object. The <code>fromAction</code>
   * corresponds to the <code>fromAction</code> string in the faces-config.xml
   * navigation rule.
   * 
   * @param action
   *       new fromAction
   */    
    public void setFromAction(String action)
    {
      mFromAction = action;
    }

  /**
   * Gets the outcome stored in this object. The <code>outcome</code>
   * corresponds to the <code>outcome</code> string in the faces-config.xml
   * navigation rule.
   * 
   * @return <code>String</code> containing the fromAction
   */    
  public String getOutcome()
  {
    return mOutcome;
  }

  /**
   * Sets the fromAction for this object. The <code>fromAction</code>
   * corresponds to the <code>fromAction</code> string in the faces-config.xml
   * navigation rule.
   * 
   * @param outcome
   *       new outcome
   */ 
  public void setOutcome(String outcome)
  {
    mOutcome = outcome;
  }   
    
}
