/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule.model;

import java.util.Date;
import org.apache.myfaces.custom.schedule.model.Interval;

public class HalfHourInterval
extends Interval {
    public static final long HALF_HOUR = 1800000L;

    public HalfHourInterval(Date startTime, Date maxEnd) {
        super(null, startTime, new Date(Math.min(startTime.getTime() + 1800000L, maxEnd.getTime())));
    }

    private HalfHourInterval(String label, Date startTime, Date endTime) {
        super(label, startTime, endTime);
    }

    public static Interval next(Interval interval, Date maxEnd) {
        Date startTime = interval.getEndTime();
        if (startTime.before(maxEnd)) {
            Date endTime = new Date(Math.min(startTime.getTime() - startTime.getTime() % 1800000L + 1800000L, maxEnd.getTime()));
            return new HalfHourInterval(null, startTime, endTime);
        }
        return null;
    }
}

