/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.context.FormData;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.AutoSubmitUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.CoreFormData;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.FormInputRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.LabelAndMessageRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.uix.SelectItemSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleSelectOneRenderer
extends FormInputRenderer {
    private PropertyKey _valuePassThruKey;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SimpleSelectOneRenderer.class);

    public SimpleSelectOneRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._valuePassThruKey = type.findKey("valuePassThru");
    }

    @Override
    protected Object getSubmittedValue(FacesContext context, UIComponent component, String clientId) {
        Object submittedValue = super.getSubmittedValue(context, component, clientId);
        boolean valuePassThru = this.getValuePassThru(this.getFacesBean(component));
        if (submittedValue == null && valuePassThru) {
            submittedValue = "";
        }
        return submittedValue;
    }

    public static Object getItemValue(FacesContext context, UIComponent component, SelectItem item, Converter converter, boolean valuePassThru, int index) {
        if (!valuePassThru) {
            return IntegerUtils.getString((int)index);
        }
        Object itemValue = item.getValue();
        if (itemValue != null && converter != null) {
            itemValue = converter.getAsString(context, component, itemValue);
        }
        return itemValue;
    }

    public static boolean encodeOption(FacesContext context, RenderingContext arc, UIComponent component, SelectItem item, Converter converter, boolean valuePassThru, int index, boolean isSelected) throws IOException {
        String description;
        if (item == null) {
            return false;
        }
        if (item.isDisabled() && !Boolean.TRUE.equals(arc.getAgent().getCapabilities().get(TrinidadAgent.CAP_SUPPORTS_DISABLED_OPTIONS))) {
            return false;
        }
        Object itemValue = SimpleSelectOneRenderer.getItemValue(context, component, item, converter, valuePassThru, index);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("option", null);
        if (item.isDisabled()) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        if (itemValue == null) {
            itemValue = "";
        }
        writer.writeAttribute("value", itemValue, null);
        if (isSelected) {
            writer.writeAttribute("selected", (Object)Boolean.TRUE, null);
        }
        if ((description = item.getDescription()) != null && !"".equals(description)) {
            writer.writeAttribute("title", (Object)description, null);
        }
        writer.writeText((Object)item.getLabel(), null);
        writer.endElement("option");
        return true;
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        boolean valuePassThru = this.getValuePassThru(this.getFacesBean(component));
        if (!valuePassThru) {
            return this._convertIndexedSubmittedValue(context, component, submittedValue);
        }
        return super.getConvertedValue(context, component, submittedValue);
    }

    private Object _convertIndexedSubmittedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        List<SelectItem> selectItems;
        int index;
        FacesBean bean = this.getFacesBean(component);
        Converter converter = this.getConverter(bean);
        if (converter == null) {
            converter = this.getDefaultConverter(context, bean);
        }
        if ((index = SimpleSelectOneRenderer.__getIndex(submittedValue, selectItems = this.getSelectItems(component, converter, true))) < 0) {
            return null;
        }
        SelectItem item = selectItems.get(index);
        if (item != null) {
            Object converted = item.getValue();
            if (converter != null && converted != null) {
                converted = converter.getAsObject(context, component, converted.toString());
            }
            return converted;
        }
        return null;
    }

    @Override
    protected void encodeAllAsElement(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        FormData fData;
        Converter converter = this.getConverter(bean);
        if (converter == null) {
            converter = this.getDefaultConverter(context, bean);
        }
        boolean valuePassThru = this.getValuePassThru(bean);
        if (this.isAutoSubmit(bean)) {
            AutoSubmitUtils.writeDependencies(context, arc);
        }
        if ((fData = arc.getFormData()) != null) {
            ((CoreFormData)fData).addOnSubmitConverterValidators(component, (Converter)(valuePassThru ? converter : null), valuePassThru ? this.getValidators(bean) : null, this.getClientId(context, component), this.isImmediate(bean), this.getRequired(bean), this.getRequiredMessageKey());
        }
        List<SelectItem> selectItems = this.getSelectItems(component, converter, false);
        int selectedIndex = this._getSelectedIndex(context, component, bean, selectItems, converter, valuePassThru);
        ResponseWriter writer = context.getResponseWriter();
        boolean simple = this.getSimple(bean);
        if (simple) {
            writer.startElement("span", component);
            this.renderRootDomElementStyles(context, arc, component, bean);
        }
        this.encodeElementContent(context, arc, component, bean, selectItems, selectedIndex, converter, valuePassThru);
        if (this.isHiddenLabelRequired(arc)) {
            this.renderShortDescAsHiddenLabel(context, arc, component, bean);
        }
        if (simple) {
            writer.endElement("span");
        }
    }

    protected abstract void encodeElementContent(FacesContext var1, RenderingContext var2, UIComponent var3, FacesBean var4, List<SelectItem> var5, int var6, Converter var7, boolean var8) throws IOException;

    @Override
    protected void renderNonElementContent(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        String text;
        if (this.getValue(bean) == null) {
            return;
        }
        Converter converter = this.getConverter(bean);
        if (converter == null) {
            converter = this.getDefaultConverter(context, bean);
        }
        boolean valuePassThru = this.getValuePassThru(bean);
        List<SelectItem> selectItems = this.getSelectItems(component, converter, false);
        int selectedIndex = this._getSelectedIndex(context, component, bean, selectItems, converter, valuePassThru);
        if (selectedIndex >= 0) {
            SelectItem item = selectItems.get(selectedIndex);
            text = item.getLabel();
        } else {
            text = this.getUnselectedLabel(bean);
        }
        context.getResponseWriter().writeText((Object)text, null);
    }

    @Override
    protected String getRequiredMessageKey() {
        return "org.apache.myfaces.trinidad.UIXSelectOne.REQUIRED";
    }

    protected List<SelectItem> getSelectItems(UIComponent component, Converter converter) {
        return this.getSelectItems(component, converter, false);
    }

    protected List<SelectItem> getSelectItems(UIComponent component, Converter converter, boolean filteredItems) {
        return SelectItemSupport.getSelectItems(component, converter, filteredItems);
    }

    protected boolean getValuePassThru(FacesBean bean) {
        Object o = bean.getProperty(this._valuePassThruKey);
        if (o == null) {
            o = this._valuePassThruKey.getDefault();
        }
        assert (o != null);
        return Boolean.TRUE.equals(o);
    }

    protected String getUnselectedLabel(FacesBean bean) {
        return null;
    }

    static int __getIndex(Object submittedValue, List<SelectItem> selectItems) {
        if ("".equals(submittedValue)) {
            return -1;
        }
        try {
            int index = Integer.parseInt(submittedValue.toString());
            if (-1 < index && SimpleSelectOneRenderer.countSelectItems(selectItems) > index) {
                return index;
            }
            throw new IndexOutOfBoundsException(_LOG.getMessage("SELECTONE_SUBMITTEDVALUE_INDEX_OUTSIDE_BOUNDS", new Object[]{index, selectItems.size() - 1}));
        }
        catch (NumberFormatException ne) {
            throw new NumberFormatException(_LOG.getMessage("SELECTONE_CANNOT_CONVERT_SUBMITTEDVALUE_INDEX_INTO_INTEGER", new Object[]{submittedValue.toString(), ne}));
        }
    }

    private static int countSelectItems(List<SelectItem> selectItems) {
        int count = 0;
        for (SelectItem item : selectItems) {
            count += SimpleSelectOneRenderer.calcItems(item);
        }
        return count;
    }

    private static int calcItems(SelectItem item) {
        if (item instanceof SelectItemGroup) {
            int count = 0;
            SelectItem[] items = ((SelectItemGroup)item).getSelectItems();
            for (int i = 0; i < items.length; ++i) {
                count += SimpleSelectOneRenderer.calcItems(items[i]);
            }
            return count;
        }
        return 1;
    }

    private int _findIndex(Object value, List<SelectItem> selectItems) {
        int size = selectItems.size();
        for (int i = 0; i < size; ++i) {
            int result;
            SelectItem item = selectItems.get(i);
            if (item == null || (result = this.resolveIndex(item, value, i)) < 0) continue;
            return result;
        }
        return -1;
    }

    private int resolveIndex(SelectItem item, Object value, int index) {
        Object itemValue;
        if (item instanceof SelectItemGroup) {
            for (SelectItem subItem : ((SelectItemGroup)item).getSelectItems()) {
                int result;
                if ((result = this.resolveIndex(subItem, value, index++)) < 0) continue;
                return result;
            }
        } else if (value == null ? (itemValue = item.getValue()) == null || "".equals(itemValue) : value.equals(item.getValue()) || value.getClass().isEnum() && item.getValue() != null && value.toString().equals(item.getValue().toString())) {
            return index;
        }
        return -1;
    }

    protected String getAutoSubmitScript(RenderingContext arc, FacesBean bean) {
        String source = LabelAndMessageRenderer.__getCachedClientId(arc);
        boolean immediate = this.isImmediate(bean);
        return AutoSubmitUtils.getSubmitScript(arc, source, "autosub", immediate);
    }

    private int _getSelectedIndex(FacesContext context, UIComponent component, FacesBean bean, List<SelectItem> selectItems, Converter converter, boolean valuePassThru) {
        Object value;
        Object submittedValue = this.getSubmittedValue(bean);
        if (submittedValue != null && !valuePassThru) {
            return SimpleSelectOneRenderer.__getIndex(submittedValue, selectItems);
        }
        if (submittedValue == null) {
            value = this.getValue(bean);
        } else if (converter != null) {
            try {
                value = converter.getAsObject(context, component, submittedValue.toString());
            }
            catch (ConverterException ce) {
                _LOG.warning((Throwable)ce);
                value = null;
            }
        } else {
            value = submittedValue;
        }
        int index = this._findIndex(value, selectItems);
        if (value != null && index < 0 && _LOG.isWarning()) {
            _LOG.warning("CANNOT_FIND_SELECTED_ITEM_MATCHING_VALUE", new Object[]{value, component});
        }
        return index;
    }
}

