/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.config.upload;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.context.Window;
import org.apache.myfaces.trinidad.context.WindowManager;
import org.apache.myfaces.trinidad.model.ExtendedUploadedFile;
import org.apache.myfaces.trinidad.model.UploadedFile;
import org.apache.myfaces.trinidadinternal.share.util.CaboHttpUtils;

public final class UploadedFiles
implements Serializable {
    private long _totalMemory;
    private long _totalDiskSpace;
    private String _characterEncoding;
    private final Map<String, List<UploadedFile>> _map = new HashMap<String, List<UploadedFile>>();
    private static final long serialVersionUID = 3371575393458911349L;
    private static final String _UPLOADED_FILES_KEY = "org.apache.myfaces.trinidadinternal.webapp.UploadedFiles";

    public static UploadedFiles getUploadedFiles(FacesContext context) {
        return UploadedFiles.getUploadedFiles(context.getExternalContext());
    }

    public static UploadedFiles getUploadedFiles(ExternalContext externalContext) {
        Map requestMap = externalContext.getRequestMap();
        return (UploadedFiles)requestMap.get(_UPLOADED_FILES_KEY);
    }

    public static UploadedFiles getUploadedFiles(HttpServletRequest req) {
        return (UploadedFiles)req.getAttribute(_UPLOADED_FILES_KEY);
    }

    public static synchronized UploadedFiles getUploadedFilesForWindow(FacesContext context) {
        return UploadedFiles.getUploadedFilesForWindow(context.getExternalContext());
    }

    public static synchronized UploadedFiles getUploadedFilesForWindow(ExternalContext externalContext) {
        RequestContext requestContext = RequestContext.getCurrentInstance();
        String windowId = UploadedFiles._getCurrentWindowId(externalContext, requestContext);
        UploadedFiles files = null;
        if (externalContext.getRequest() instanceof HttpServletRequest) {
            HttpSession session = ((HttpServletRequest)externalContext.getRequest()).getSession();
            Map<String, UploadedFiles> uploadedFilesSessionMap = (Map<String, UploadedFiles>)session.getAttribute(_UPLOADED_FILES_KEY);
            if (uploadedFilesSessionMap == null) {
                uploadedFilesSessionMap = UploadedFiles.__saveUploadedFilesForWindow(files, externalContext, requestContext);
            }
            files = (UploadedFiles)uploadedFilesSessionMap.get(windowId);
        }
        if (files == null) {
            files = new UploadedFiles();
            UploadedFiles.__saveUploadedFilesForWindow(files, externalContext, requestContext);
        }
        return files;
    }

    public static void setCharacterEncoding(ExternalContext externalContext, String encoding) {
        UploadedFiles files = UploadedFiles.getUploadedFiles(externalContext);
        UploadedFiles._setCharacterEncoding(files, encoding);
    }

    public static void setCharacterEncoding(HttpServletRequest req, String encoding) {
        UploadedFiles files = (UploadedFiles)req.getAttribute(_UPLOADED_FILES_KEY);
        UploadedFiles._setCharacterEncoding(files, encoding);
    }

    public static void setCharacterEncoding(PortletRequest req, String encoding) {
        UploadedFiles files = (UploadedFiles)req.getAttribute(_UPLOADED_FILES_KEY);
        UploadedFiles._setCharacterEncoding(files, encoding);
    }

    private static void _setCharacterEncoding(UploadedFiles files, String encoding) {
        if (files != null) {
            files._characterEncoding = encoding;
        }
    }

    public UploadedFile getUploadedFile(String name) {
        List<UploadedFile> files = this.getUploadedFileList(name);
        if (files == null || files.isEmpty()) {
            return null;
        }
        for (UploadedFile file : files) {
            if (file == null) continue;
            return file;
        }
        return null;
    }

    public List<UploadedFile> getUploadedFileList(String name) {
        List<UploadedFile> files = this._map.get(name);
        if (files == null || files.isEmpty()) {
            return null;
        }
        return files;
    }

    public static void retrieveUploadedFilesForWindow(ExternalContext externalContext, String name) {
        List<UploadedFile> windowFileList;
        UploadedFiles windowFiles = UploadedFiles.getUploadedFilesForWindow(externalContext);
        if (windowFiles != null && (windowFileList = windowFiles.getUploadedFileList(name)) != null && !windowFileList.isEmpty()) {
            UploadedFiles requestFiles = (UploadedFiles)externalContext.getRequestMap().get(_UPLOADED_FILES_KEY);
            if (requestFiles == null) {
                requestFiles = new UploadedFiles(externalContext);
            }
            for (UploadedFile windowFile : windowFileList) {
                requestFiles.__put(name, windowFile);
            }
            windowFiles.getUploadedFileMap().remove(name);
            UploadedFiles.__saveUploadedFilesForWindow(windowFiles, externalContext, RequestContext.getCurrentInstance());
        }
    }

    public Iterator<String> getUploadedNames() {
        return this._map.keySet().iterator();
    }

    public Map<String, List<UploadedFile>> getUploadedFileMap() {
        return this._map;
    }

    public void dispose() {
        for (List<UploadedFile> files : this._map.values()) {
            if (files == null) continue;
            for (UploadedFile file : files) {
                if (file == null) continue;
                file.dispose();
            }
        }
        this._map.clear();
        this._totalMemory = 0L;
        this._totalDiskSpace = 0L;
    }

    UploadedFiles(HttpServletRequest req) {
        this();
        req.setAttribute(_UPLOADED_FILES_KEY, (Object)this);
    }

    UploadedFiles(ExternalContext externalContext) {
        this();
        externalContext.getRequestMap().put(_UPLOADED_FILES_KEY, this);
    }

    UploadedFiles() {
    }

    void __put(String name, UploadedFile file) {
        List<UploadedFile> files = this._map.get(name);
        if (files == null) {
            files = new ArrayList<UploadedFile>();
        }
        Object fixFilename = null;
        fixFilename = file instanceof ExtendedUploadedFile ? new FixFilenameProperties((ExtendedUploadedFile)file, this._characterEncoding) : new FixFilename(file, this._characterEncoding);
        files.add((UploadedFile)fixFilename);
        this._map.put(name, files);
    }

    public long getTotalMemory() {
        return this._totalMemory;
    }

    public long getTotalDiskSpace() {
        return this._totalDiskSpace;
    }

    static synchronized Map<String, UploadedFiles> __saveUploadedFilesForWindow(UploadedFiles files, ExternalContext externalContext, RequestContext requestContext) {
        HashMap<String, UploadedFiles> uploadedFilesSessionMap = null;
        String windowId = UploadedFiles._getCurrentWindowId(externalContext, requestContext);
        if (externalContext.getRequest() instanceof HttpServletRequest) {
            HttpSession session = ((HttpServletRequest)externalContext.getRequest()).getSession();
            uploadedFilesSessionMap = (HashMap<String, UploadedFiles>)session.getAttribute(_UPLOADED_FILES_KEY);
            if (uploadedFilesSessionMap == null) {
                uploadedFilesSessionMap = new HashMap<String, UploadedFiles>();
            }
            uploadedFilesSessionMap.put(windowId, files);
            session.setAttribute(_UPLOADED_FILES_KEY, uploadedFilesSessionMap);
        }
        return uploadedFilesSessionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    private static String _getCurrentWindowId(ExternalContext externalContext, RequestContext requestContext) {
        Window currWindow;
        WindowManager wm;
        if (requestContext != null && (wm = requestContext.getWindowManager()) != null && (currWindow = wm.getCurrentWindow(externalContext)) != null) {
            return currWindow.getId();
        }
        return "null";
    }

    public static class FixFilenameProperties
    extends ExtendedUploadedFile {
        private static final long serialVersionUID = -7477694533769079788L;
        private FixFilename _file;
        private ExtendedUploadedFile _original;

        public FixFilenameProperties() {
        }

        public FixFilenameProperties(ExtendedUploadedFile file, String encoding) {
            this._original = file;
            this._file = new FixFilename((UploadedFile)file, encoding);
        }

        public String getFilename() {
            return this._file.getFilename();
        }

        public String getContentType() {
            return this._file.getContentType();
        }

        public long getLength() {
            return this._file.getLength();
        }

        public Object getOpaqueData() {
            return this._file.getOpaqueData();
        }

        public InputStream getInputStream() throws IOException {
            return this._file.getInputStream();
        }

        public Map<String, Object> getProperties() {
            return this._original.getProperties();
        }

        public void dispose() {
            this._file.dispose();
        }
    }

    public static class FixFilename
    implements UploadedFile,
    Serializable {
        private static final long serialVersionUID = -8586594511769079566L;
        private UploadedFile _file;
        private String _encoding;
        private String _fixFilename = null;

        public FixFilename() {
        }

        public FixFilename(UploadedFile file, String encoding) {
            this._file = file;
            this._encoding = encoding;
        }

        public String getFilename() {
            if (this._fixFilename == null) {
                String filename = this._file.getFilename();
                if (this._encoding == null) {
                    return filename;
                }
                try {
                    this._fixFilename = CaboHttpUtils.decodeRequestParameter(filename, this._encoding, null);
                }
                catch (UnsupportedEncodingException uee) {
                    assert (false);
                    this._fixFilename = filename;
                }
            }
            return this._fixFilename;
        }

        public String getContentType() {
            return this._file.getContentType();
        }

        public long getLength() {
            return this._file.getLength();
        }

        public Object getOpaqueData() {
            return this._file.getOpaqueData();
        }

        public InputStream getInputStream() throws IOException {
            return this._file.getInputStream();
        }

        public void dispose() {
            this._file.dispose();
        }
    }
}

