/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.webapp;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ProjectStage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.trinidad.config.Configurator;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.resource.CachingResourceLoader;
import org.apache.myfaces.trinidad.resource.DirectoryResourceLoader;
import org.apache.myfaces.trinidad.resource.ResourceLoader;
import org.apache.myfaces.trinidad.resource.ServletContextResourceLoader;
import org.apache.myfaces.trinidad.util.URLUtils;

public class ResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = 4547362994406585148L;
    public static final String DEBUG_INIT_PARAM = "org.apache.myfaces.trinidad.resource.DEBUG";
    public static final long ONE_YEAR_MILLIS = 31363200000L;
    private static final long _INITIAL_WAIT_TIME = 10L;
    private static final long _MAX_WAIT_TIME = 60000L;
    private static final Class[] _DECORATOR_SIGNATURE = new Class[]{ResourceLoader.class};
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ResourceServlet.class);
    private static final int _BUFFER_SIZE = 2048;
    private volatile boolean _debug;
    private volatile ConcurrentMap<String, ResourceLoader> _loaders;
    private volatile ConcurrentMap<String, Class<?>> _loaderErrors;
    private volatile FacesContextFactory _facesContextFactory;
    private volatile Lifecycle _lifecycle;
    private volatile ProjectStage _projectStage;
    private static final String[] _INCLUDED_HEADERS;

    public void destroy() {
        this._loaders = null;
        this._loaderErrors = null;
        this._facesContextFactory = null;
        this._lifecycle = null;
        super.destroy();
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this._facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
        }
        catch (FacesException e) {
            Throwable rootCause = e.getCause();
            if (rootCause == null) {
                throw e;
            }
            throw new ServletException(e.getMessage(), rootCause);
        }
        this._lifecycle = new _ResourceLifecycle();
        this._initDebug(config);
        this._loaders = new ConcurrentHashMap<String, ResourceLoader>();
        this._loaderErrors = new ConcurrentHashMap();
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean hasFacesContext = false;
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            if (this._isContextValid(context)) {
                hasFacesContext = true;
            } else {
                context.release();
            }
        }
        if (!hasFacesContext) {
            Configurator.disableConfiguratorServices(request);
            context = this._facesContextFactory.getFacesContext((Object)this.getServletContext(), (Object)request, (Object)response, this._lifecycle);
        }
        try {
            super.service(request, response);
        }
        catch (ServletException e) {
            this._logServiceException(e, request);
            throw e;
        }
        catch (IOException e) {
            if (!ResourceServlet._canIgnore(e)) {
                this._logServiceException(e, request);
            }
            throw e;
        }
        catch (RuntimeException e) {
            this._logServiceException(e, request);
            throw e;
        }
        catch (Error e) {
            this._logServiceException(e, request);
            throw e;
        }
        finally {
            if (!hasFacesContext) {
                context.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String resourcePath;
        ResourceLoader loader = this._getResourceLoader(request);
        URL url = loader.getResource(resourcePath = this.getResourcePath(request));
        if (url == null) {
            this._logURLNotFound(request, loader, resourcePath);
            response.sendError(404);
            return;
        }
        URLConnection connection = url.openConnection();
        connection.setDoInput(true);
        connection.setDoOutput(false);
        connection.connect();
        this._setHeaders(connection, response, loader);
        InputStream in = connection.getInputStream();
        ServletOutputStream out = response.getOutputStream();
        byte[] buffer = new byte[2048];
        try {
            ResourceServlet._pipeBytes(in, (OutputStream)out, buffer);
        }
        finally {
            try {
                in.close();
            }
            finally {
                out.close();
            }
        }
    }

    protected long getLastModified(HttpServletRequest request) {
        try {
            ResourceLoader loader = this._getResourceLoader(request);
            String resourcePath = this.getResourcePath(request);
            URL url = loader.getResource(resourcePath);
            if (url == null) {
                return super.getLastModified(request);
            }
            return URLUtils.getLastModified(url);
        }
        catch (IOException e) {
            return super.getLastModified(request);
        }
    }

    protected String getResourcePath(HttpServletRequest request) {
        return request.getServletPath() + request.getPathInfo();
    }

    private boolean _isContextValid(FacesContext context) {
        ExternalContext ec = context.getExternalContext();
        return ec != null && ec.getRequest() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private ResourceLoader _getResourceLoader(String servletPath) {
        loader = null;
        try {
            key = "META-INF/servlets/resources" + servletPath + ".resources";
            cl = Thread.currentThread().getContextClassLoader();
            url = cl.getResource(key);
            if (url != null) {
                r = new InputStreamReader(url.openStream());
                br = new BufferedReader(r);
                try {
                    className = br.readLine();
                    if (className == null) ** GOTO lbl34
                    className = className.trim();
                    clazz = cl.loadClass(className);
                    try {
                        decorator = clazz.getConstructor(ResourceServlet._DECORATOR_SIGNATURE);
                        context = this.getServletContext();
                        tempdir = (File)context.getAttribute("javax.servlet.context.tempdir");
                        delegate = new DirectoryResourceLoader(tempdir);
                        loader = (ResourceLoader)decorator.newInstance(new Object[]{delegate});
                    }
                    catch (InvocationTargetException e) {
                        this._logLoaderException(e, servletPath);
                        loader = (ResourceLoader)clazz.newInstance();
                    }
                    catch (NoSuchMethodException e) {
                        loader = (ResourceLoader)clazz.newInstance();
                    }
                }
                finally {
                    br.close();
                }
            } else {
                if (ResourceServlet._LOG.isWarning()) {
                    ResourceServlet._LOG.warning("Unable to find ResourceLoader for ResourceServlet at servlet path:{0}\nCause: Could not find resource:{1}", new Object[]{servletPath, key});
                }
                loader = new ServletContextResourceLoader(this.getServletContext()){

                    @Override
                    public URL getResource(String path) throws IOException {
                        return super.getResource(path);
                    }
                };
            }
lbl34:
            // 5 sources

            if (!this._debug && loader.isCachable()) {
                loader = new CachingResourceLoader(loader);
            }
        }
        catch (IllegalAccessException e) {
            loader = this.logExceptionAndReturnFailureLoader(e, servletPath);
        }
        catch (InstantiationException e) {
            loader = this.logExceptionAndReturnFailureLoader(e, servletPath);
        }
        catch (ClassNotFoundException e) {
            loader = this.logExceptionAndReturnFailureLoader(e, servletPath);
        }
        catch (IOException e) {
            loader = this.logExceptionAndReturnFailureLoader(e, servletPath);
        }
        return loader;
    }

    private ResourceLoader _getResourceLoader(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        ResourceLoader loader = (ResourceLoader)this._loaders.get(servletPath);
        if (loader == null) {
            loader = this._getResourceLoader(servletPath);
            this._registerLoader(servletPath, loader);
        }
        return loader;
    }

    private void _registerLoader(String servletPath, ResourceLoader loader) {
        this._loaders.put(servletPath, loader);
    }

    private void _logLoaderException(Exception e, String servletPath) {
        Class previousExceptionClass = (Class)this._loaderErrors.get(servletPath);
        if (previousExceptionClass == null || previousExceptionClass != e.getClass()) {
            _LOG.severe(e);
            if (e.getCause() != null) {
                _LOG.severe("Caused by ", e.getCause());
            }
            this._loaderErrors.put(servletPath, e.getClass());
        }
    }

    private void _logURLNotFound(HttpServletRequest request, ResourceLoader loader, String resourcePath) {
        if (_LOG.isWarning()) {
            FacesContext context = FacesContext.getCurrentInstance();
            Object servletContext = this._getServletContextFromFacesContext(context);
            _LOG.warning("URL for resource not found.\n  resourcePath: {0}\n  loader class name: {1}\n  request.pathTranslated: {2}\n  request.requestURL: {3}\n  FacesContext: {4}\n  ServletContext: {5}\n", new Object[]{resourcePath, loader, request.getPathTranslated(), request.getRequestURL(), context, servletContext});
        }
    }

    private void _logServiceException(Throwable e, ServletRequest request) {
        FacesContext context = FacesContext.getCurrentInstance();
        Object servletContext = this._getServletContextFromFacesContext(context);
        HttpServletRequest sr = (HttpServletRequest)request;
        _LOG.severe("An Exception occured in ResourceServlet.service().\n  request.pathTranslated:" + sr.getPathTranslated() + "\n" + "  request.requestURI:" + sr.getRequestURI() + "\n" + "  FacesContext: " + context + "\n" + "  ServletContext: " + servletContext + "\n", e);
    }

    private Object _getServletContextFromFacesContext(FacesContext context) {
        ExternalContext ec = null;
        Object sc = null;
        if (context != null && (ec = context.getExternalContext()) != null) {
            sc = ec.getContext();
        }
        return sc;
    }

    private static void _pipeBytes(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        int length;
        while ((length = in.read(buffer)) >= 0) {
            out.write(buffer, 0, length);
        }
    }

    private void _initDebug(ServletConfig config) {
        String debug = config.getInitParameter(DEBUG_INIT_PARAM);
        if (debug == null) {
            debug = config.getServletContext().getInitParameter(DEBUG_INIT_PARAM);
        }
        ProjectStage currentStage = this._getFacesProjectStage(config.getServletContext());
        if (debug != null) {
            this._debug = "true".equalsIgnoreCase(debug);
        } else {
            boolean bl = this._debug = !ProjectStage.Production.equals((Object)currentStage);
        }
        if (this._debug) {
            if (ProjectStage.Production.equals((Object)currentStage)) {
                _LOG.warning("RESOURCESERVLET_IN_DEBUG_MODE", DEBUG_INIT_PARAM);
            } else {
                _LOG.info("RESOURCESERVLET_IN_DEBUG_MODE", DEBUG_INIT_PARAM);
            }
        }
    }

    private ProjectStage _getFacesProjectStage(ServletContext servletContext) {
        if (this._projectStage == null) {
            String stageName = null;
            try {
                InitialContext ctx = new InitialContext();
                Object temp = ctx.lookup("java:comp/env/jsf/ProjectStage");
                if (temp != null) {
                    if (temp instanceof String) {
                        stageName = (String)temp;
                    } else if (_LOG.isSevere()) {
                        _LOG.severe("Invalid JNDI lookup for key java:comp/env/jsf/ProjectStage");
                    }
                }
            }
            catch (NamingException ctx) {
                // empty catch block
            }
            if (stageName == null) {
                stageName = servletContext.getInitParameter("javax.faces.PROJECT_STAGE");
            }
            if (stageName != null) {
                try {
                    this._projectStage = ProjectStage.valueOf((String)stageName);
                    return this._projectStage;
                }
                catch (IllegalArgumentException e) {
                    _LOG.severe("Couldn't discover the current project stage", e);
                }
            } else if (_LOG.isInfo()) {
                _LOG.info("Couldn't discover the current project stage, using " + ProjectStage.Production);
            }
            this._projectStage = ProjectStage.Production;
        }
        return this._projectStage;
    }

    private void _setHeaders(URLConnection connection, HttpServletResponse response, ResourceLoader loader) {
        Map<String, List<String>> headerMap;
        long lastModified;
        URL url;
        String resourcePath;
        String contentType = ResourceLoader.getContentType(loader, connection);
        if ((contentType == null || "content/unknown".equals(contentType)) && (contentType = (resourcePath = (url = connection.getURL()).getPath()).endsWith(".css") ? "text/css" : (resourcePath.endsWith(".js") ? "application/x-javascript" : (resourcePath.endsWith(".cur") || resourcePath.endsWith(".ico") ? "image/vnd.microsoft.icon" : this.getServletContext().getMimeType(resourcePath)))) == null) {
            _LOG.warning("ResourceServlet._setHeaders(): Content type for {0} is NULL!\nCause: Unknown file extension", resourcePath);
        }
        if (contentType != null) {
            response.setContentType(contentType);
            int contentLength = connection.getContentLength();
            if (contentLength >= 0) {
                response.setContentLength(contentLength);
            }
        }
        try {
            lastModified = URLUtils.getLastModified(connection);
        }
        catch (IOException exception) {
            lastModified = 0L;
        }
        if (lastModified == 0L) {
            response.setDateHeader("Last-Modified", lastModified);
        }
        String cacheControl = connection.getHeaderField("cache-control");
        Long expires = connection.getExpiration();
        if (!this._debug && null == cacheControl && 0L == expires) {
            cacheControl = "Public";
            expires = System.currentTimeMillis() + 31363200000L;
        }
        if (null != cacheControl) {
            response.setHeader("Cache-Control", cacheControl);
        }
        if (0L != expires) {
            response.setDateHeader("Expires", expires.longValue());
        }
        if (null != (headerMap = connection.getHeaderFields())) {
            for (Map.Entry<String, List<String>> entry : connection.getHeaderFields().entrySet()) {
                String key = entry.getKey();
                if (Arrays.binarySearch(_INCLUDED_HEADERS, key.toLowerCase()) < 0 || null == entry.getValue()) continue;
                for (String value : entry.getValue()) {
                    response.addHeader(key, value);
                }
            }
        }
    }

    private static boolean _canIgnore(Throwable t) {
        String message;
        if (t instanceof InterruptedIOException) {
            return true;
        }
        if (t instanceof SocketException) {
            return true;
        }
        return t instanceof IOException && (message = t.getMessage()) != null && (message.indexOf("Broken pipe") >= 0 || message.indexOf("abort") >= 0);
    }

    private ResourceLoader logExceptionAndReturnFailureLoader(Exception e, String servletPath) {
        this._logLoaderException(e, servletPath);
        return new _ExponentialBackoffResourceLoader(servletPath);
    }

    static {
        Object[] tempArray = new String[]{"age", "content-language", "content-location", "content-md5", "content-disposition", "content-range", "date", "link", "p3p", "refresh", "retry-after", "strict-transport-security", "trailer", "warning"};
        Arrays.sort(tempArray);
        _INCLUDED_HEADERS = tempArray;
    }

    private static class _ResourceLifecycle
    extends Lifecycle {
        private _ResourceLifecycle() {
        }

        public void execute(FacesContext p0) throws FacesException {
        }

        public PhaseListener[] getPhaseListeners() {
            return null;
        }

        public void removePhaseListener(PhaseListener p0) {
        }

        public void render(FacesContext p0) throws FacesException {
        }

        public void addPhaseListener(PhaseListener p0) {
        }
    }

    private final class _ExponentialBackoffResourceLoader
    extends ResourceLoader {
        private volatile long _nextBackoffTime;
        private final long _initialTimeStamp;
        private final String _servletPath;

        protected _ExponentialBackoffResourceLoader(String servletPath) {
            super(null);
            this._initialTimeStamp = System.currentTimeMillis();
            this._nextBackoffTime = this._initialTimeStamp + 10L;
            this._servletPath = servletPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected URL findResource(String name) throws IOException {
            long currentTime = System.currentTimeMillis();
            if (currentTime > this._nextBackoffTime) {
                _ExponentialBackoffResourceLoader _ExponentialBackoffResourceLoader2 = this;
                synchronized (_ExponentialBackoffResourceLoader2) {
                    if (currentTime > this._nextBackoffTime) {
                        ResourceLoader newLoader = ResourceServlet.this._getResourceLoader(this._servletPath);
                        if (!(newLoader instanceof _ExponentialBackoffResourceLoader)) {
                            ResourceServlet.this._registerLoader(this._servletPath, newLoader);
                            _LOG.warning("Fixed resource loader for servlet path: {0}", this._servletPath);
                            return newLoader.getResource(name);
                        }
                        this._nextBackoffTime += Math.min((currentTime - this._initialTimeStamp) * 2L, 60000L);
                    }
                }
            }
            return null;
        }
    }
}

