/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.OutOfDiskSpaceException;
import jetbrains.exodus.io.AbstractDataWriter;
import jetbrains.exodus.io.Block;
import jetbrains.exodus.io.FileDataReader;
import jetbrains.exodus.io.FileDataWriter;
import jetbrains.exodus.io.LockingManager;
import jetbrains.exodus.io.RemoveBlockType;
import jetbrains.exodus.io.SharedMappedFilesCache;
import jetbrains.exodus.io.SharedOpenFilesCache;
import jetbrains.exodus.kotlin.KodusKt;
import jetbrains.exodus.log.LogUtil;
import jetbrains.exodus.system.JVMConstants;
import jetbrains.exodus.util.SharedRandomAccessFile;
import jetbrains.exodus.util.UnsafeHolder;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u0000 02\u00020\u0001:\u00010B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0012H\u0014J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u0016J\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0018H\u0014J\u0018\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0018H\u0002J\b\u0010\u001e\u001a\u00020\u0010H\u0016J\u0018\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020\u0012H\u0016J\b\u0010&\u001a\u00020\u0012H\u0014J\u0018\u0010'\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J\b\u0010(\u001a\u00020\u0012H\u0002J \u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Ljetbrains/exodus/io/FileDataWriter;", "Ljetbrains/exodus/io/AbstractDataWriter;", "reader", "Ljetbrains/exodus/io/FileDataReader;", "lockId", "", "(Ljetbrains/exodus/io/FileDataReader;Ljava/lang/String;)V", "block", "Ljetbrains/exodus/io/FileDataReader$FileBlock;", "dirChannel", "Ljava/nio/channels/FileChannel;", "file", "Ljava/io/RandomAccessFile;", "lockingManager", "Ljetbrains/exodus/io/LockingManager;", "useNio", "", "clearImpl", "", "closeImpl", "ensureFile", "errorMsg", "lock", "timeout", "", "lockInfo", "openOrCreateBlockImpl", "address", "length", "openOrCreateFile", "release", "removeBlock", "blockAddress", "rbt", "Ljetbrains/exodus/io/RemoveBlockType;", "removeFileFromFileCache", "Ljava/io/File;", "syncDirectory", "syncImpl", "truncateBlock", "warnCantFsyncDirectory", "write", "Ljetbrains/exodus/io/Block;", "b", "", "off", "", "len", "Companion", "xodus-environment"})
public class FileDataWriter
extends AbstractDataWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileDataReader reader;
    @Nullable
    private FileChannel dirChannel;
    @NotNull
    private final LockingManager lockingManager;
    @Nullable
    private RandomAccessFile file;
    @Nullable
    private FileDataReader.FileBlock block;
    private boolean useNio;
    @NotNull
    private static final String DELETED_FILE_EXTENSION = ".del";
    @NotNull
    private static final Lazy<Unit> warnIfWindows$delegate = LazyKt.lazy((Function0)Companion.warnIfWindows.2.INSTANCE);
    @Nullable
    private static final Method setUninterruptibleMethod = JVMConstants.INSTANCE.getIS_JAVA9_OR_HIGHER() ? (Method)UnsafeHolder.INSTANCE.doPrivileged((Function0)Companion.setUninterruptibleMethod.1.INSTANCE) : (Method)null;

    @JvmOverloads
    public FileDataWriter(@NotNull FileDataReader reader, @Nullable String lockId) {
        Intrinsics.checkNotNullParameter((Object)((Object)reader), (String)"reader");
        this.reader = reader;
        FileChannel channel = null;
        if (!JVMConstants.getIS_ANDROID()) {
            try {
                channel = FileChannel.open(this.reader.getDir().toPath(), new OpenOption[0]);
                channel.force(false);
            }
            catch (IOException e) {
                channel = null;
                this.warnCantFsyncDirectory();
            }
        }
        this.dirChannel = channel;
        this.lockingManager = new LockingManager(this.reader.getDir(), lockId);
    }

    public /* synthetic */ FileDataWriter(FileDataReader fileDataReader, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(fileDataReader, string);
    }

    @NotNull
    public Block write(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        try {
            this.ensureFile("Can't write, FileDataWriter is closed").write(b, off, len);
        }
        catch (IOException ioe) {
            if (this.lockingManager.getUsableSpace() < (long)len) {
                throw new OutOfDiskSpaceException((Throwable)ioe);
            }
            throw ioe;
        }
        FileDataReader.FileBlock fileBlock = this.block;
        if (fileBlock == null) {
            throw new ExodusException("Can't write, FileDataWriter is closed");
        }
        return fileBlock;
    }

    public boolean lock(long timeout) {
        return this.lockingManager.lock(timeout);
    }

    public boolean release() {
        return this.lockingManager.release();
    }

    @Nullable
    public String lockInfo() {
        return this.lockingManager.lockInfo();
    }

    @Override
    protected void syncImpl() {
        RandomAccessFile randomAccessFile = this.file;
        if (randomAccessFile != null) {
            RandomAccessFile it = randomAccessFile;
            boolean bl = false;
            FileDataWriter.Companion.forceSync(it);
        }
    }

    @Override
    protected void closeImpl() {
        this.ensureFile("Can't close already closed FileDataWriter").close();
        this.file = null;
        FileChannel fileChannel = this.dirChannel;
        if (fileChannel != null) {
            fileChannel.close();
        }
        this.dirChannel = null;
        this.block = null;
    }

    @Override
    protected void clearImpl() {
        File[] fileArray = LogUtil.listFiles(this.reader.getDir());
        Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"listFiles(reader.dir)");
        File[] fileArray2 = fileArray;
        int n = 0;
        int n2 = fileArray2.length;
        while (n < n2) {
            File file = fileArray2[n];
            ++n;
            if (!file.canWrite()) {
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                FileDataWriter.Companion.setWritable(file);
            }
            if (!file.exists() || file.delete()) continue;
            throw new ExodusException(Intrinsics.stringPlus((String)"Failed to delete ", (Object)file));
        }
    }

    @Override
    @NotNull
    protected FileDataReader.FileBlock openOrCreateBlockImpl(long address, long length) {
        FileDataReader.FileBlock fileBlock;
        FileDataReader.FileBlock it = fileBlock = new FileDataReader.FileBlock(address, this.reader);
        boolean bl = false;
        this.openOrCreateFile(it, length);
        return fileBlock;
    }

    @Override
    public void syncDirectory() {
        FileChannel fileChannel = this.dirChannel;
        if (fileChannel != null) {
            FileChannel channel = fileChannel;
            boolean bl = false;
            try {
                FileDataWriter.Companion.asUninterruptible(channel).force(false);
            }
            catch (IOException e) {
                this.warnCantFsyncDirectory();
            }
        }
    }

    public void removeBlock(long blockAddress, @NotNull RemoveBlockType rbt) {
        boolean deleted;
        Intrinsics.checkNotNullParameter((Object)rbt, (String)"rbt");
        FileDataReader.FileBlock file = new FileDataReader.FileBlock(blockAddress, this.reader);
        this.removeFileFromFileCache(file);
        FileDataWriter.Companion.setWritable(file);
        boolean bl = deleted = rbt == RemoveBlockType.Delete ? file.delete() : Companion.renameFile(file);
        if (!deleted) {
            throw new ExodusException(Intrinsics.stringPlus((String)"Failed to delete ", (Object)file.getAbsolutePath()));
        }
        Companion.getLogger().info((Function0)new Function0<Object>(file){
            final /* synthetic */ FileDataReader.FileBlock $file;
            {
                this.$file = $file;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return Intrinsics.stringPlus((String)"Deleted file ", (Object)this.$file.getAbsolutePath());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncateBlock(long blockAddress, long length) {
        FileDataReader.FileBlock file = new FileDataReader.FileBlock(blockAddress, this.reader);
        this.removeFileFromFileCache(file);
        FileDataWriter.Companion.setWritable(file);
        Closeable closeable = (Closeable)new SharedRandomAccessFile((File)file, "rw");
        Throwable throwable = null;
        try {
            SharedRandomAccessFile f = (SharedRandomAccessFile)closeable;
            boolean bl = false;
            f.setLength(length);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Companion.getLogger().info((Function0)new Function0<Object>(file, length){
            final /* synthetic */ FileDataReader.FileBlock $file;
            final /* synthetic */ long $length;
            {
                this.$file = $file;
                this.$length = $length;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Truncated file " + this.$file.getAbsolutePath() + " to length = " + this.$length;
            }
        });
    }

    private final void warnCantFsyncDirectory() {
        this.dirChannel = null;
        FileDataWriter.Companion.getWarnIfWindows();
    }

    private final void removeFileFromFileCache(File file) {
        SharedOpenFilesCache.getInstance().removeFile(file);
        if (this.useNio) {
            SharedMappedFilesCache.getInstance().removeFileBuffer(file);
        }
    }

    private final RandomAccessFile openOrCreateFile(FileDataReader.FileBlock block, long length) {
        FileDataReader.FileBlock fileBlock;
        FileDataReader.FileBlock $this$openOrCreateFile_u24lambda_u2d4 = fileBlock = block;
        boolean bl = false;
        if (!$this$openOrCreateFile_u24lambda_u2d4.canWrite()) {
            FileDataWriter.Companion.setWritable($this$openOrCreateFile_u24lambda_u2d4);
        }
        String string = "rw";
        File file = fileBlock;
        RandomAccessFile result = new RandomAccessFile(file, string);
        result.seek(length);
        if (length != result.length()) {
            result.setLength(length);
            FileDataWriter.Companion.forceSync(result);
        }
        this.file = result;
        this.block = block;
        return result;
    }

    private final RandomAccessFile ensureFile(String errorMsg) {
        RandomAccessFile randomAccessFile = this.file;
        if (randomAccessFile != null) {
            RandomAccessFile randomAccessFile2;
            RandomAccessFile file = randomAccessFile;
            boolean bl = false;
            if (file.getChannel().isOpen()) {
                return file;
            }
            RandomAccessFile it = randomAccessFile2 = this.openOrCreateFile((FileDataReader.FileBlock)KodusKt.getNotNull((Object)this.block), file.length());
            boolean bl2 = false;
            file.close();
            return randomAccessFile2;
        }
        throw new ExodusException(errorMsg);
    }

    @JvmOverloads
    public FileDataWriter(@NotNull FileDataReader reader) {
        Intrinsics.checkNotNullParameter((Object)((Object)reader), (String)"reader");
        this(reader, null, 2, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0012H\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Ljetbrains/exodus/io/FileDataWriter$Companion;", "Lmu/KLogging;", "()V", "DELETED_FILE_EXTENSION", "", "setUninterruptibleMethod", "Ljava/lang/reflect/Method;", "warnIfWindows", "", "getWarnIfWindows", "()Lkotlin/Unit;", "warnIfWindows$delegate", "Lkotlin/Lazy;", "forceSync", "file", "Ljava/io/RandomAccessFile;", "renameFile", "", "Ljava/io/File;", "setWritable", "asUninterruptible", "Ljava/nio/channels/FileChannel;", "xodus-environment"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        private final Unit getWarnIfWindows() {
            Lazy lazy = warnIfWindows$delegate;
            lazy.getValue();
            return Unit.INSTANCE;
        }

        private final FileChannel asUninterruptible(FileChannel $this$asUninterruptible) {
            Method method = setUninterruptibleMethod;
            if (method != null) {
                method.invoke((Object)$this$asUninterruptible, new Object[0]);
            }
            return $this$asUninterruptible;
        }

        public final boolean renameFile(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String name = file.getName();
            String string = file.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            String string2 = name.substring(0, StringsKt.indexOf$default((CharSequence)name, (String)".xd", (int)0, (boolean)false, (int)6, null));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return file.renameTo(new File(string, Intrinsics.stringPlus((String)string2, (Object)FileDataWriter.DELETED_FILE_EXTENSION)));
        }

        private final void forceSync(RandomAccessFile file) {
            block3: {
                try {
                    FileChannel fileChannel = file.getChannel();
                    Intrinsics.checkNotNullExpressionValue((Object)fileChannel, (String)"file.channel");
                    this.asUninterruptible(fileChannel).force(false);
                }
                catch (ClosedChannelException closedChannelException) {
                }
                catch (IOException ioe) {
                    if (!file.getChannel().isOpen()) break block3;
                    throw ioe;
                }
            }
        }

        private final void setWritable(File file) {
            if (file.exists() && !file.setWritable(true)) {
                throw new ExodusException(Intrinsics.stringPlus((String)"Failed to set writable ", (Object)file.getAbsolutePath()));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

