/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.gems.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.portals.bridges.common.GenericServletPortlet;

public class FilePortlet
extends GenericServletPortlet {
    private String defaultPortalParam = "org.apache.jetspeed.Path";
    private final String PATH_SEPARATOR = "/";
    static final int BLOCK_SIZE = 4096;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
    }

    private boolean getBooleanFromParameter(String param) {
        if (param == null) {
            return false;
        }
        return param.equalsIgnoreCase("true");
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        InitParameterState state = new InitParameterState(this.getPortletConfig());
        String fileName = (String)request.getAttribute(state.portalParam);
        if (fileName == null) {
            fileName = request.getPreferences().getValue("file", null);
        }
        if (fileName == null) {
            response.setContentType("text/html");
            response.getWriter().println("<p>A source document was not provided.</p>");
            return;
        }
        String path = this.concatenatePaths(state.folder, fileName);
        this.setContentType(path, response);
        List<String> paths = this.fallback(path, request.getLocale().getLanguage(), state);
        this.renderFile(response, paths, state);
    }

    protected List<String> fallback(String path, String language, InitParameterState state) {
        LinkedList<String> paths = new LinkedList<String>();
        if (state.useLanguage) {
            String fallbackPath = path;
            File temp = new File(path);
            String parentPath = temp.getParent();
            String name = temp.getName();
            path = this.concatenatePaths(parentPath, language);
            path = this.concatenatePaths(path, name);
            paths.add(path);
            paths.add(fallbackPath);
        } else {
            paths.add(path);
        }
        return paths;
    }

    protected void setContentType(String path, RenderResponse response) {
        if (path.endsWith(".html")) {
            response.setContentType("text/html");
        } else if (path.endsWith(".pdf")) {
            response.setContentType("application/pdf");
        } else if (path.endsWith(".zip")) {
            response.setContentType("application/zip");
        } else if (path.endsWith(".csv")) {
            response.setContentType("text/csv");
        } else if (path.endsWith(".xml")) {
            response.setContentType("text/xml");
        } else if (path.endsWith(".xls")) {
            File f = new File(path);
            response.setContentType("application/vnd.ms-excel");
            response.addProperty("Content-Type", "application/vnd.ms-excel");
            response.addProperty("Content-Disposition", "inline; filename=" + f.getName());
        } else if (path.endsWith(".psml") || path.endsWith(".link")) {
            response.setContentType("text/xml");
        } else {
            response.setContentType("text/html");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderFile(RenderResponse response, List<String> paths, InitParameterState state) throws PortletException, IOException {
        boolean drained = false;
        for (String fileName : paths) {
            InputStream is = null;
            try {
                is = state.useFileSystem ? new FileInputStream(fileName) : this.getPortletContext().getResourceAsStream(fileName);
                if (is == null) continue;
                FilePortlet.drain(is, response.getPortletOutputStream());
                response.getPortletOutputStream().flush();
                is.close();
                is = null;
                drained = true;
                break;
            }
            catch (Exception e) {}
            continue;
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        if (!drained) {
            String fileName = paths.get(0);
            byte[] bytes = ("File " + fileName + " not found.").getBytes();
            response.getPortletOutputStream().write(bytes);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drain(InputStream r, OutputStream w) throws IOException {
        byte[] bytes = new byte[4096];
        try {
            int length = r.read(bytes);
            while (length != -1) {
                if (length != 0) {
                    w.write(bytes, 0, length);
                }
                length = r.read(bytes);
            }
        }
        finally {
            bytes = null;
        }
    }

    protected String concatenatePaths(String base, String path) {
        String result = "";
        if (base == null) {
            if (path == null) {
                return result;
            }
            return path;
        }
        if (path == null) {
            return base;
        }
        if (base.endsWith("/")) {
            if (path.startsWith("/")) {
                result = base.concat(path.substring(1));
                return result;
            }
        } else if (!path.startsWith("/")) {
            result = base.concat("/").concat(path);
            return result;
        }
        return base.concat(path);
    }

    class InitParameterState {
        boolean useLanguage = false;
        boolean useFileSystem = false;
        String folder;
        String portalParam;

        InitParameterState(PortletConfig config) {
            String portalParam;
            this.useLanguage = FilePortlet.this.getBooleanFromParameter(config.getInitParameter("useLanguage"));
            this.useFileSystem = FilePortlet.this.getBooleanFromParameter(config.getInitParameter("useFilesystem"));
            this.folder = config.getInitParameter("folder");
            if (this.folder == null) {
                this.folder = "";
            }
            if ((portalParam = config.getInitParameter("portalParam")) == null) {
                this.portalParam = FilePortlet.this.defaultPortalParam;
            }
        }
    }
}

