/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.util;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;

public class SystemUtils {
    public static final String UNKNOWN_OS = "unknown";
    public static final String UNKNOWN_VERSION = "na";
    public static final String UNKNOWN_ARCH = "unknown";
    private static final String _osName;
    private static final String _osVersion;
    private static final String _osArch;
    private static final boolean _isWindows;
    private static final String _osPid;
    private static int _osPidInt;

    private SystemUtils() {
    }

    public static final String getOSName() {
        return _osName;
    }

    public static final String getOSVersion() {
        return _osVersion;
    }

    public static final String getOSArch() {
        return _osArch;
    }

    public static final String getProcessPid() {
        return _osPid;
    }

    public static final int getProcessPidAsInt() {
        return _osPidInt;
    }

    public static final boolean isWindows() {
        return _isWindows;
    }

    public static final String getOSConfigSuffix() {
        if (_osName.contains(" ")) {
            return _osName.substring(0, _osName.indexOf(32)).toLowerCase();
        }
        return _osName;
    }

    public static final String getOSString() {
        return _osName + " " + _osVersion + " " + _osArch;
    }

    private static int parseInt(String str, int defaultVal) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return defaultVal;
        }
    }

    static {
        int atIndex;
        _osName = System.getProperty("os.name", "unknown");
        _osVersion = System.getProperty("os.version", UNKNOWN_VERSION);
        _osArch = System.getProperty("os.arch", "unknown");
        _isWindows = _osName.toLowerCase().contains("windows");
        RuntimeMXBean rtb = ManagementFactory.getRuntimeMXBean();
        String processName = rtb.getName();
        if (processName != null && (atIndex = processName.indexOf(64)) > 0) {
            _osPid = processName.substring(0, atIndex);
            _osPidInt = SystemUtils.parseInt(_osPid, -1);
        } else {
            _osPid = null;
        }
    }
}

