/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.controller.v6_1.category;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.qpid.server.management.plugin.ManagementException;
import org.apache.qpid.server.management.plugin.ManagementResponse;
import org.apache.qpid.server.management.plugin.controller.ConverterHelper;
import org.apache.qpid.server.management.plugin.controller.GenericLegacyConfiguredObject;
import org.apache.qpid.server.management.plugin.controller.LegacyConfiguredObject;
import org.apache.qpid.server.management.plugin.controller.LegacyManagementController;
import org.apache.qpid.server.management.plugin.controller.TypeController;
import org.apache.qpid.server.management.plugin.controller.v6_1.category.LegacyCategoryController;
import org.apache.qpid.server.model.ConfiguredObject;

public class BrokerController
extends LegacyCategoryController {
    private static final String CONNECTION_SESSION_COUNT_LIMIT = "connection.sessionCountLimit";
    private static final String CONNECTION_HEART_BEAT_DELAY = "connection.heartBeatDelay";
    private static final String CONNECTION_CLOSE_WHEN_NO_ROUTE = "connection.closeWhenNoRoute";
    private static final Map<String, String> BROKER_ATTRIBUTES_MOVED_INTO_CONTEXT = new HashMap<String, String>();
    public static final String TYPE = "Broker";

    BrokerController(LegacyManagementController legacyManagementController, Set<TypeController> typeControllers) {
        super(legacyManagementController, TYPE, new String[]{"SystemConfig"}, TYPE, typeControllers);
    }

    @Override
    public LegacyConfiguredObject convertNextVersionLegacyConfiguredObject(LegacyConfiguredObject object) {
        return new LegacyBroker(this.getManagementController(), object);
    }

    @Override
    protected Map<String, Object> convertAttributesToNextVersion(ConfiguredObject<?> root, List<String> path, Map<String, Object> attributes) {
        LinkedHashMap<String, Object> converted = new LinkedHashMap<String, Object>(attributes);
        Map context = (Map)converted.get("context");
        LinkedHashMap<String, String> newContext = new LinkedHashMap<String, String>();
        if (context != null) {
            newContext.putAll(context);
        }
        converted.put("context", newContext);
        for (String attributeName : BROKER_ATTRIBUTES_MOVED_INTO_CONTEXT.keySet()) {
            Object value = converted.remove(attributeName);
            if (value == null) continue;
            newContext.put(BROKER_ATTRIBUTES_MOVED_INTO_CONTEXT.get(attributeName), String.valueOf(value));
        }
        converted.remove("statisticsReportingResetEnabled");
        Object statisticsReportingPeriod = converted.get("statisticsReportingPeriod");
        if (statisticsReportingPeriod != null && !newContext.containsKey("qpid.broker.statisticsReportPattern") && (ConverterHelper.toInt(statisticsReportingPeriod) > 0 || ConverterHelper.isContextVariable(statisticsReportingPeriod))) {
            newContext.put("qpid.broker.statisticsReportPattern", "messagesIn=${messagesIn}, bytesIn=${bytesIn:byteunit}, messagesOut=${messagesOut}, bytesOut=${bytesOut:byteunit}");
        }
        return converted;
    }

    static {
        BROKER_ATTRIBUTES_MOVED_INTO_CONTEXT.put(CONNECTION_SESSION_COUNT_LIMIT, "qpid.port.sessionCountLimit");
        BROKER_ATTRIBUTES_MOVED_INTO_CONTEXT.put(CONNECTION_HEART_BEAT_DELAY, "qpid.port.heartbeatDelay");
        BROKER_ATTRIBUTES_MOVED_INTO_CONTEXT.put(CONNECTION_CLOSE_WHEN_NO_ROUTE, "qpid.port.closeWhenNoRoute");
    }

    static class LegacyBroker
    extends GenericLegacyConfiguredObject {
        private static final String MODEL_VERSION = "modelVersion";

        LegacyBroker(LegacyManagementController managementController, LegacyConfiguredObject nextVersionLegacyConfiguredObject) {
            super(managementController, nextVersionLegacyConfiguredObject, BrokerController.TYPE);
        }

        @Override
        public Collection<String> getAttributeNames() {
            return Stream.concat(super.getAttributeNames().stream(), BROKER_ATTRIBUTES_MOVED_INTO_CONTEXT.keySet().stream()).collect(Collectors.toSet());
        }

        @Override
        public Object getAttribute(String name) {
            if (MODEL_VERSION.equals(name)) {
                return this.getManagementController().getVersion();
            }
            if (BROKER_ATTRIBUTES_MOVED_INTO_CONTEXT.containsKey(name)) {
                Object value = this.getMovedAttribute(name);
                if (value != null) {
                    if (BrokerController.CONNECTION_SESSION_COUNT_LIMIT.equals(name)) {
                        return ConverterHelper.toInt(value);
                    }
                    if (BrokerController.CONNECTION_HEART_BEAT_DELAY.equals(name)) {
                        return ConverterHelper.toLong(value);
                    }
                    if (BrokerController.CONNECTION_CLOSE_WHEN_NO_ROUTE.equals(name)) {
                        return ConverterHelper.toBoolean(value);
                    }
                }
                return null;
            }
            return super.getAttribute(name);
        }

        @Override
        public Object getActualAttribute(String name) {
            if (MODEL_VERSION.equals(name)) {
                return this.getManagementController().getVersion();
            }
            if (BROKER_ATTRIBUTES_MOVED_INTO_CONTEXT.containsKey(name)) {
                return this.getMovedAttribute(name);
            }
            return super.getActualAttribute(name);
        }

        private Object getMovedAttribute(String name) {
            Map context = (Map)super.getAttribute("context");
            if (context != null) {
                String contextVariable = BROKER_ATTRIBUTES_MOVED_INTO_CONTEXT.get(name);
                return context.get(contextVariable);
            }
            return null;
        }

        @Override
        public ManagementResponse invoke(String operation, Map<String, Object> parameters, boolean isSecure) {
            if ("resetStatistics".equalsIgnoreCase(operation)) {
                throw ManagementException.createGoneManagementException("Method 'resetStatistics' was removed");
            }
            return super.invoke(operation, parameters, isSecure);
        }

        @Override
        public boolean isSecureAttribute(String name) {
            return !BROKER_ATTRIBUTES_MOVED_INTO_CONTEXT.containsKey(name) && super.isSecureAttribute(name);
        }

        @Override
        public boolean isOversizedAttribute(String name) {
            return !BROKER_ATTRIBUTES_MOVED_INTO_CONTEXT.containsKey(name) && super.isOversizedAttribute(name);
        }

        @Override
        public LegacyConfiguredObject getParent(String category) {
            if ("SystemConfig".equals(category)) {
                LegacyConfiguredObject nextVersionParent = this.getNextVersionLegacyConfiguredObject().getParent(category);
                return new GenericLegacyConfiguredObject(this.getManagementController(), nextVersionParent, category);
            }
            return super.getParent(category);
        }
    }
}

