/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.cleaner.Cleaner;
import com.sleepycat.je.cleaner.ExpirationProfile;
import com.sleepycat.je.cleaner.FileSelector;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.cleaner.FilesToMigrate;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.TTL;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.Pair;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UtilizationCalculator
implements EnvConfigObserver {
    private final EnvironmentImpl env;
    private final Cleaner cleaner;
    private final Logger logger;
    private FilesToMigrate filesToMigrate;
    private volatile int currentMinUtilization = -1;
    private volatile int currentMaxUtilization = -1;
    private volatile int predictedMinUtilization = -1;
    private volatile int predictedMaxUtilization = -1;

    UtilizationCalculator(EnvironmentImpl env, Cleaner cleaner) {
        this.env = env;
        this.cleaner = cleaner;
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.filesToMigrate = new FilesToMigrate(env);
        env.addConfigObserver(this);
    }

    int getCurrentMinUtilization() {
        return this.currentMinUtilization;
    }

    int getCurrentMaxUtilization() {
        return this.currentMaxUtilization;
    }

    int getPredictedMinUtilization() {
        return this.predictedMinUtilization;
    }

    int getPredictedMaxUtilization() {
        return this.predictedMaxUtilization;
    }

    synchronized Pair<Long, Integer> getBestFile(SortedMap<Long, FileSummary> fileSummaryMap, boolean forceCleaning) {
        Level logLevel;
        String reason;
        Long fileChosen;
        long firstActiveTxnFile;
        if (fileSummaryMap.size() == 0) {
            LoggerUtils.logMsg(this.logger, this.env, Level.SEVERE, "Can't clean, map is empty.");
            return null;
        }
        FileSelector fileSelector = this.cleaner.getFileSelector();
        NavigableSet<Long> inProgressFiles = fileSelector.getInProgressFiles();
        NavigableSet<Long> safeToDeleteFiles = fileSelector.getSafeToDeleteFiles();
        ExpirationProfile expProfile = this.cleaner.getExpirationProfile();
        long currentTime = TTL.currentSystemTime();
        expProfile.refresh(currentTime);
        int totalThreshold = this.cleaner.minUtilization;
        int fileThreshold = this.cleaner.minFileUtilization;
        int twoPassThreshold = this.cleaner.twoPassThreshold;
        int twoPassGap = this.cleaner.twoPassGap;
        int minAge = this.cleaner.minAge;
        boolean gradualExpiration = this.cleaner.gradualExpiration;
        boolean expirationEnabled = this.env.isExpirationEnabled();
        long firstActiveFile = fileSummaryMap.lastKey();
        long firstActiveTxnLsn = this.env.getTxnManager().getFirstActiveLsn();
        if (firstActiveTxnLsn != -1L && firstActiveFile > (firstActiveTxnFile = DbLsn.getFileNumber(firstActiveTxnLsn))) {
            firstActiveFile = firstActiveTxnFile;
        }
        long lastFileToClean = firstActiveFile - (long)minAge;
        Long bestFile = null;
        int bestFileAvgUtil = 101;
        int bestFileMinUtil = 0;
        int bestFileMaxUtil = 0;
        Long bestGradualFile = null;
        int bestGradualFileMaxUtil = 101;
        long currentTotalSize = 0L;
        long currentMinObsoleteSize = 0L;
        long currentMaxObsoleteSize = 0L;
        long predictedTotalSize = 0L;
        long predictedMinObsoleteSize = 0L;
        long predictedMaxObsoleteSize = 0L;
        for (Map.Entry<Long, FileSummary> entry : fileSummaryMap.entrySet()) {
            int maxGradualObsoleteSize;
            int minGradualObsoleteSize;
            int maxObsoleteSize;
            int minObsoleteSize;
            int expiredGradualSize;
            int expiredSize;
            Long file = entry.getKey();
            long fileNum = file;
            FileSummary summary = entry.getValue();
            if (expirationEnabled) {
                Pair<Integer, Integer> expiredSizes = expProfile.getExpiredBytes(fileNum, currentTime);
                expiredSize = Math.min(expiredSizes.first(), summary.totalSize);
                expiredGradualSize = gradualExpiration ? Math.min(expiredSizes.second(), summary.totalSize) : expiredSize;
            } else {
                expiredSize = 0;
                expiredGradualSize = 0;
            }
            if (safeToDeleteFiles.contains(file)) {
                minObsoleteSize = summary.totalSize;
                maxObsoleteSize = summary.totalSize;
                minGradualObsoleteSize = summary.totalSize;
                maxGradualObsoleteSize = summary.totalSize;
            } else {
                int obsoleteSize = summary.getObsoleteSize();
                minObsoleteSize = Math.max(obsoleteSize, expiredSize);
                maxObsoleteSize = Math.min(obsoleteSize + expiredSize, summary.totalSize);
                minGradualObsoleteSize = Math.max(obsoleteSize, expiredGradualSize);
                maxGradualObsoleteSize = Math.min(obsoleteSize + expiredGradualSize, summary.totalSize);
            }
            currentTotalSize += (long)summary.totalSize;
            currentMinObsoleteSize += (long)minObsoleteSize;
            currentMaxObsoleteSize += (long)maxObsoleteSize;
            if (inProgressFiles.contains(file)) {
                int utilizedSize = summary.totalSize - minObsoleteSize;
                predictedTotalSize += (long)utilizedSize;
                continue;
            }
            predictedTotalSize += (long)summary.totalSize;
            predictedMinObsoleteSize += (long)minGradualObsoleteSize;
            predictedMaxObsoleteSize += (long)maxGradualObsoleteSize;
            if (fileNum > lastFileToClean) continue;
            int thisMinUtil = FileSummary.utilization(maxObsoleteSize, summary.totalSize);
            int thisMaxUtil = FileSummary.utilization(minObsoleteSize, summary.totalSize);
            int thisAvgUtil = (thisMinUtil + thisMaxUtil) / 2;
            if (bestFile == null || thisAvgUtil < bestFileAvgUtil) {
                bestFile = file;
                bestFileAvgUtil = thisAvgUtil;
                bestFileMinUtil = thisMinUtil;
                bestFileMaxUtil = thisMaxUtil;
            }
            int thisGradualMaxUtil = FileSummary.utilization(minGradualObsoleteSize, summary.totalSize);
            if (bestGradualFile != null && thisGradualMaxUtil >= bestGradualFileMaxUtil) continue;
            bestGradualFile = file;
            bestGradualFileMaxUtil = thisGradualMaxUtil;
        }
        int currentMinUtil = FileSummary.utilization(currentMaxObsoleteSize, currentTotalSize);
        int currentMaxUtil = FileSummary.utilization(currentMinObsoleteSize, currentTotalSize);
        int predictedMinUtil = FileSummary.utilization(predictedMaxObsoleteSize, predictedTotalSize);
        int predictedMaxUtil = FileSummary.utilization(predictedMinObsoleteSize, predictedTotalSize);
        this.currentMinUtilization = currentMinUtil;
        this.currentMaxUtilization = currentMaxUtil;
        this.predictedMinUtilization = predictedMinUtil;
        this.predictedMaxUtilization = predictedMaxUtil;
        if (predictedMinUtil < totalThreshold) {
            fileChosen = bestFile;
            reason = "predicted min util is below minUtilization";
        } else if (bestGradualFileMaxUtil < fileThreshold) {
            fileChosen = bestGradualFile;
            reason = "file has avg util below minFileUtilization";
        } else if (this.filesToMigrate.hasNext(fileSummaryMap)) {
            fileChosen = this.filesToMigrate.next(fileSummaryMap);
            reason = "there are more forceCleanFiles";
        } else if (forceCleaning) {
            fileChosen = bestFile;
            reason = "forced for testing";
        } else {
            fileChosen = null;
            reason = "no file selected";
        }
        String bestFileMsg = "";
        String twoPassMsg = "";
        int pass1RequiredUtil = -1;
        if (fileChosen != null && fileChosen.equals(bestFile)) {
            bestFileMsg = ", chose file with util min: " + bestFileMinUtil + " max: " + bestFileMaxUtil + " avg: " + bestFileAvgUtil;
            if (bestFileMaxUtil > twoPassThreshold && bestFileMaxUtil - bestFileMinUtil >= twoPassGap) {
                pass1RequiredUtil = twoPassThreshold;
                twoPassMsg = ", 2-pass cleaning";
            }
        }
        Level level = logLevel = fileChosen != null ? Level.INFO : Level.FINE;
        if (this.logger.isLoggable(logLevel)) {
            LoggerUtils.logMsg(this.logger, this.env, logLevel, "Clean file " + (fileChosen != null ? "0x" + Long.toHexString(fileChosen) : "none") + ": " + reason + twoPassMsg + ", current util min: " + currentMinUtil + " max: " + currentMaxUtil + ", predicted util min: " + predictedMinUtil + " max: " + predictedMaxUtil + bestFileMsg);
        }
        return fileChosen != null ? new Pair<Long, Integer>(fileChosen, pass1RequiredUtil) : null;
    }

    @Override
    public synchronized void envConfigUpdate(DbConfigManager cm, EnvironmentMutableConfig ignore) {
        this.filesToMigrate = new FilesToMigrate(this.env);
    }
}

