/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;

public abstract class RemotingSerializable {
    private static final Charset CHARSET_UTF8 = StandardCharsets.UTF_8;

    public static byte[] encode(Object obj) {
        if (obj == null) {
            return null;
        }
        String json = RemotingSerializable.toJson(obj, false);
        return json.getBytes(CHARSET_UTF8);
    }

    public static String toJson(Object obj, boolean prettyFormat) {
        if (prettyFormat) {
            return JSON.toJSONString((Object)obj, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.PrettyFormat});
        }
        return JSON.toJSONString((Object)obj);
    }

    public static <T> T decode(byte[] data, Class<T> classOfT) {
        if (data == null) {
            return null;
        }
        return RemotingSerializable.fromJson(data, classOfT);
    }

    public static <T> List<T> decodeList(byte[] data, Class<T> classOfT) {
        if (data == null) {
            return null;
        }
        String json = new String(data, CHARSET_UTF8);
        return JSON.parseArray((String)json, classOfT);
    }

    public static <T> T fromJson(String json, Class<T> classOfT) {
        return (T)JSON.parseObject((String)json, classOfT);
    }

    private static <T> T fromJson(byte[] data, Class<T> classOfT) {
        return (T)JSON.parseObject((byte[])data, classOfT);
    }

    public byte[] encode() {
        String json = this.toJson();
        if (json != null) {
            return json.getBytes(CHARSET_UTF8);
        }
        return null;
    }

    public byte[] encode(JSONWriter.Feature ... features) {
        String json = JSON.toJSONString((Object)this, (JSONWriter.Feature[])features);
        return json.getBytes(CHARSET_UTF8);
    }

    public String toJson() {
        return this.toJson(false);
    }

    public String toJson(boolean prettyFormat) {
        return RemotingSerializable.toJson(this, prettyFormat);
    }
}

