/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.producer;

import apache.rocketmq.v2.Publishing;
import apache.rocketmq.v2.Resource;
import apache.rocketmq.v2.RetryPolicy;
import apache.rocketmq.v2.Settings;
import java.time.Duration;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.rocketmq.client.java.impl.ClientSettings;
import org.apache.rocketmq.client.java.impl.ClientType;
import org.apache.rocketmq.client.java.impl.UserAgent;
import org.apache.rocketmq.client.java.retry.ExponentialBackoffRetryPolicy;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.apache.rocketmq.shaded.com.google.common.base.MoreObjects;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.Futures;
import org.apache.rocketmq.shaded.com.google.protobuf.util.Durations;
import org.apache.rocketmq.shaded.org.slf4j.Logger;
import org.apache.rocketmq.shaded.org.slf4j.LoggerFactory;

public class ProducerSettings
extends ClientSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProducerSettings.class);
    private final Set<String> topics;
    private volatile int maxBodySizeBytes = 0x400000;
    private volatile boolean validateMessageType = true;

    public ProducerSettings(String clientId, Endpoints accessPoint, ExponentialBackoffRetryPolicy retryPolicy, Duration requestTimeout, Set<String> topics) {
        super(clientId, ClientType.PRODUCER, accessPoint, retryPolicy, requestTimeout);
        this.topics = topics;
    }

    public int getMaxBodySizeBytes() {
        return this.maxBodySizeBytes;
    }

    public boolean isValidateMessageType() {
        return this.validateMessageType;
    }

    @Override
    public Settings toProtobuf() {
        Publishing publishing = Publishing.newBuilder().addAllTopics(this.topics.stream().map(name -> Resource.newBuilder().setName((String)name).build()).collect(Collectors.toList())).setValidateMessageType(this.validateMessageType).build();
        Settings.Builder builder = Settings.newBuilder().setAccessPoint(this.accessPoint.toProtobuf()).setClientType(this.clientType.toProtobuf()).setRequestTimeout(Durations.fromNanos(this.requestTimeout.toNanos())).setPublishing(publishing);
        return builder.setBackoffPolicy(this.retryPolicy.toProtobuf()).setUserAgent(UserAgent.INSTANCE.toProtoBuf()).build();
    }

    @Override
    public void applySettingsCommand(Settings settings) {
        Settings.PubSubCase pubSubCase = settings.getPubSubCase();
        if (!Settings.PubSubCase.PUBLISHING.equals(pubSubCase)) {
            LOGGER.error("[Bug] Issued settings not match with the client type, clientId={}, pubSubCase={}, clientType={}", new Object[]{this.clientId, pubSubCase, this.clientType});
            return;
        }
        RetryPolicy backoffPolicy = settings.getBackoffPolicy();
        Publishing publishing = settings.getPublishing();
        org.apache.rocketmq.client.java.retry.RetryPolicy exist = this.retryPolicy;
        this.retryPolicy = exist.updateBackoff(backoffPolicy);
        this.validateMessageType = settings.getPublishing().getValidateMessageType();
        this.maxBodySizeBytes = publishing.getMaxBodySize();
        this.arrivedFuture.setFuture(Futures.immediateVoidFuture());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("clientId", this.clientId).add("clientType", (Object)this.clientType).add("accessPoint", this.accessPoint).add("retryPolicy", this.retryPolicy).add("requestTimeout", this.requestTimeout).add("topics", this.topics).add("maxBodySizeBytes", this.maxBodySizeBytes).toString();
    }
}

