/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.scalar;

import com.fasterxml.jackson.databind.JavaType;
import io.protostuff.InputEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import org.apache.servicecomb.foundation.common.utils.bean.DoubleSetter;
import org.apache.servicecomb.foundation.common.utils.bean.Setter;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;

public class DoubleReadSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        JavaType javaType = propertyDescriptor.getJavaType();
        if (Double.TYPE.equals(javaType.getRawClass())) {
            return new DoublePrimitiveSchema(protoField, propertyDescriptor);
        }
        if (Double.class.equals((Object)javaType.getRawClass()) || javaType.isJavaLangObject()) {
            return new DoubleSchema(protoField, propertyDescriptor);
        }
        ProtoUtils.throwNotSupportMerge(protoField, propertyDescriptor.getJavaType());
        return null;
    }

    private static class DoublePrimitiveSchema<T>
    extends FieldSchema<T> {
        private final DoubleSetter<T> setter;

        public DoublePrimitiveSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor.getJavaType());
            this.setter = (DoubleSetter)propertyDescriptor.getSetter();
        }

        @Override
        public int mergeFrom(InputEx input, T message) throws IOException {
            double value = input.readDouble();
            this.setter.set(message, value);
            return input.readFieldNumber();
        }
    }

    private static class DoubleSchema<T>
    extends FieldSchema<T> {
        private final Setter<T, Double> setter;

        public DoubleSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor.getJavaType());
            this.setter = (Setter)propertyDescriptor.getSetter();
        }

        @Override
        public int mergeFrom(InputEx input, T message) throws IOException {
            double value = input.readDouble();
            this.setter.set(message, (Object)value);
            return input.readFieldNumber();
        }
    }
}

