/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.client.ws;

import io.vertx.core.Future;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.common.rest.filter.HttpClientFilter;
import org.apache.servicecomb.common.rest.filter.HttpClientFilterBeforeSendRequestExecutor;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.invocation.InvocationStageTrace;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.foundation.common.utils.ExceptionUtils;
import org.apache.servicecomb.foundation.common.utils.JsonUtils;
import org.apache.servicecomb.foundation.vertx.client.ws.WebSocketClientWithContext;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.foundation.vertx.ws.VertxClientWebSocketRequestToHttpServletRequest;
import org.apache.servicecomb.foundation.vertx.ws.VertxClientWebSocketResponseToHttpServletResponse;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.apache.servicecomb.transport.rest.client.ws.RestClientRequestWebSocketWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketClientInvocation {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketClientInvocation.class);
    private static final String[] INTERNAL_HEADERS = new String[]{"x-cse-context", "x-cse-target-microservice"};
    private Invocation invocation;
    private AsyncResponse asyncResp;
    private RestOperationMeta restOperationMeta;
    private WebSocketConnectOptions webSocketClientRequest;
    private final WebSocketClientWithContext webSocketClientWithContext;
    private final List<HttpClientFilter> httpClientFilters;
    private boolean alreadyFailed = false;
    private WebSocket clientWebSocket;

    public WebSocketClientInvocation(WebSocketClientWithContext webSocketClientWithContext, List<HttpClientFilter> httpClientFilters) {
        this.webSocketClientWithContext = webSocketClientWithContext;
        this.httpClientFilters = httpClientFilters;
    }

    public void invoke(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        this.invocation = invocation;
        this.asyncResp = asyncResp;
        OperationMeta operationMeta = invocation.getOperationMeta();
        this.restOperationMeta = (RestOperationMeta)operationMeta.getExtData("swaggerRestOperation");
        String path = this.createRequestPath(this.restOperationMeta);
        IpPort ipPort = (IpPort)invocation.getEndpoint().getAddress();
        this.webSocketClientRequest = this.createWebSocketRequest(ipPort, path);
        this.webSocketClientRequest.putHeader("x-cse-target-microservice", invocation.getMicroserviceName());
        RestClientRequestWebSocketWrapper restClientRequest = new RestClientRequestWebSocketWrapper(this.webSocketClientRequest);
        invocation.getHandlerContext().put("servicecomb-invocation-hanlder-requestclient", restClientRequest);
        VertxClientWebSocketRequestToHttpServletRequest requestEx = new VertxClientWebSocketRequestToHttpServletRequest(this.webSocketClientRequest);
        ((CompletableFuture)this.executeHttpClientFilters((HttpServletRequestEx)requestEx).thenCompose(v -> {
            this.webSocketClientWithContext.runOnContext(webSocketClient -> {
                this.processServiceCombHeaders(invocation, operationMeta);
                webSocketClient.connect(this.webSocketClientRequest).onComplete(r -> invocation.getInvocationStageTrace().finishGetConnection()).compose(clientWebSocket -> {
                    this.clientWebSocket = clientWebSocket.pause();
                    this.handleResponse(invocation);
                    return Future.succeededFuture();
                }).onFailure(failure -> {
                    invocation.getTraceIdLogger().error(LOGGER, "Failed to send request, alreadyFailed:{}, local:{}, remote:{}, message={}.", new Object[]{this.alreadyFailed, this.getLocalAddress(), ipPort.getSocketAddress(), ExceptionUtils.getExceptionMessageWithoutTrace((Throwable)failure)});
                    this.fail((Throwable)failure);
                });
            });
            return CompletableFuture.completedFuture(null);
        })).exceptionally(failure -> {
            invocation.getTraceIdLogger().error(LOGGER, "Failed to send request, alreadyFailed:{}, local:{}, remote:{}, message={}.", new Object[]{this.alreadyFailed, this.getLocalAddress(), ipPort.getSocketAddress(), ExceptionUtils.getExceptionMessageWithoutTrace((Throwable)failure)});
            this.fail((Throwable)failure);
            return null;
        });
    }

    private void handleResponse(Invocation invocation) {
        invocation.getResponseExecutor().execute(() -> {
            try {
                VertxClientWebSocketResponseToHttpServletResponse responseEx = new VertxClientWebSocketResponseToHttpServletResponse(this.clientWebSocket);
                for (HttpClientFilter filter : this.httpClientFilters) {
                    Response response;
                    if (!filter.enabled() || !filter.enabledForTransport(invocation.getTransportName()) || (response = filter.afterReceiveResponse(invocation, (HttpServletResponseEx)responseEx)) == null) continue;
                    this.complete(response);
                    return;
                }
            }
            catch (Throwable e) {
                this.fail(e);
            }
        });
    }

    private void complete(Response response) {
        this.invocation.getInvocationStageTrace().finishClientFiltersResponse();
        this.asyncResp.complete(response);
    }

    private CompletableFuture<Void> executeHttpClientFilters(HttpServletRequestEx requestEx) {
        HttpClientFilterBeforeSendRequestExecutor exec = new HttpClientFilterBeforeSendRequestExecutor(this.httpClientFilters, this.invocation, requestEx);
        return exec.run();
    }

    private void processServiceCombHeaders(Invocation invocation, OperationMeta operationMeta) {
        if (invocation.isThirdPartyInvocation() && operationMeta.getConfig().isClientRequestHeaderFilterEnabled()) {
            for (String internalHeaderName : INTERNAL_HEADERS) {
                this.webSocketClientRequest.removeHeader(internalHeaderName);
            }
            return;
        }
        this.setCseContext();
    }

    private void setCseContext() {
        try {
            this.webSocketClientRequest.putHeader("x-cse-context", JsonUtils.writeUnicodeValueAsString((Object)this.invocation.getContext()));
        }
        catch (Throwable e) {
            this.invocation.getTraceIdLogger().error(LOGGER, "Failed to encode and set cseContext, message={}.", new Object[]{ExceptionUtils.getExceptionMessageWithoutTrace((Throwable)e)});
        }
    }

    private HttpMethod getMethod() {
        OperationMeta operationMeta = this.invocation.getOperationMeta();
        RestOperationMeta swaggerRestOperation = (RestOperationMeta)operationMeta.getExtData("swaggerRestOperation");
        String method = swaggerRestOperation.getHttpMethod();
        return HttpMethod.valueOf((String)method);
    }

    WebSocketConnectOptions createWebSocketRequest(IpPort ipPort, String path) {
        URIEndpointObject endpoint = (URIEndpointObject)this.invocation.getEndpoint().getAddress();
        HttpMethod method = this.getMethod();
        WebSocketConnectOptions webSocketConnectOptions = new WebSocketConnectOptions().setHost(ipPort.getHostOrIp()).setPort(Integer.valueOf(ipPort.getPort())).setSsl(Boolean.valueOf(endpoint.isSslEnabled())).setMethod(method).setTimeout((long)this.webSocketClientWithContext.getOption().getConnectTimeoutInMillis()).setURI(path);
        this.invocation.getTraceIdLogger().debug(LOGGER, "Sending request by websocket, method={}, qualifiedName={}, path={}, endpoint={}.", new Object[]{method, this.invocation.getMicroserviceQualifiedName(), path, this.invocation.getEndpoint().getEndpoint()});
        return webSocketConnectOptions;
    }

    protected String createRequestPath(RestOperationMeta swaggerRestOperation) throws Exception {
        URIEndpointObject address = (URIEndpointObject)this.invocation.getEndpoint().getAddress();
        String urlPrefix = address.getFirst("urlPrefix");
        String path = swaggerRestOperation.getPathBuilder().createRequestPath(this.invocation.getSwaggerArguments());
        if (StringUtils.isEmpty((CharSequence)urlPrefix) || path.startsWith(urlPrefix)) {
            return path;
        }
        return urlPrefix + path;
    }

    protected void fail(Throwable e) {
        if (this.alreadyFailed) {
            return;
        }
        this.alreadyFailed = true;
        InvocationStageTrace stageTrace = this.invocation.getInvocationStageTrace();
        if (stageTrace.getFinishReceiveResponse() == 0L) {
            stageTrace.finishReceiveResponse();
        }
        if (stageTrace.getStartClientFiltersResponse() == 0L) {
            stageTrace.startClientFiltersResponse();
        }
        stageTrace.finishClientFiltersResponse();
        try {
            if (e instanceof TimeoutException) {
                LOGGER.info("Request timeout, Details: {}.", (Object)e.getMessage());
                this.asyncResp.consumerFail((Throwable)new InvocationException((Response.StatusType)Response.Status.REQUEST_TIMEOUT, (Object)new CommonExceptionData("Request Timeout.")));
                return;
            }
            this.asyncResp.fail(this.invocation.getInvocationType(), e);
        }
        catch (Throwable e1) {
            this.invocation.getTraceIdLogger().error(LOGGER, "failed to invoke asyncResp, message={}", new Object[]{ExceptionUtils.getExceptionMessageWithoutTrace((Throwable)e)});
        }
    }

    private String getLocalAddress() {
        if (this.clientWebSocket == null || this.clientWebSocket.localAddress() == null) {
            return "not connected";
        }
        return this.clientWebSocket.localAddress().toString();
    }
}

