/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.impl;

import java.net.URI;
import org.apache.sling.auth.oauth_client.ClientConnection;
import org.apache.sling.auth.oauth_client.impl.OidcProviderMetadataRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component
@Designate(ocd=Config.class, factory=true)
public class OidcConnectionImpl
implements ClientConnection {
    private final Config cfg;
    private final OidcProviderMetadataRegistry metadataRegistry;
    private final String authorizationEndpoint;
    private final String tokenEndpoint;
    private final String userInfoUrl;
    private final String jwkSetURL;
    private final String issuer;
    private final boolean hasBaseUrl;

    @Activate
    public OidcConnectionImpl(Config cfg, @Reference OidcProviderMetadataRegistry metadataRegistry) {
        this.cfg = cfg;
        this.metadataRegistry = metadataRegistry;
        this.authorizationEndpoint = cfg.authorizationEndpoint();
        this.tokenEndpoint = cfg.tokenEndpoint();
        this.userInfoUrl = cfg.userInfoUrl();
        this.jwkSetURL = cfg.jwkSetURL();
        this.issuer = cfg.issuer();
        this.hasBaseUrl = !OidcConnectionImpl.isNullOrEmpty(cfg.baseUrl());
        this.isValidConfig();
    }

    private void isValidConfig() {
        if (this.hasBaseUrl && this.hasAnyManualConfigurationParameter()) {
            throw new IllegalArgumentException("Either baseUrl OR explicit endpoints (authorizationEndpoint, tokenEndpoint, userInfoUrl, jwkSetURL, issuer) must be provided, not both");
        }
        if (!this.hasBaseUrl && !this.hasAllManualConfigurationParameters()) {
            throw new IllegalArgumentException("Either baseUrl must be provided OR all explicit endpoints (authorizationEndpoint, tokenEndpoint, userInfoUrl, jwkSetURL, issuer) must be provided");
        }
    }

    private boolean hasAnyManualConfigurationParameter() {
        return !OidcConnectionImpl.isNullOrEmpty(this.tokenEndpoint) || !OidcConnectionImpl.isNullOrEmpty(this.authorizationEndpoint) || !OidcConnectionImpl.isNullOrEmpty(this.userInfoUrl) || !OidcConnectionImpl.isNullOrEmpty(this.jwkSetURL) || !OidcConnectionImpl.isNullOrEmpty(this.issuer);
    }

    private boolean hasAllManualConfigurationParameters() {
        return !OidcConnectionImpl.isNullOrEmpty(this.tokenEndpoint) && !OidcConnectionImpl.isNullOrEmpty(this.authorizationEndpoint) && !OidcConnectionImpl.isNullOrEmpty(this.userInfoUrl) && !OidcConnectionImpl.isNullOrEmpty(this.jwkSetURL) && !OidcConnectionImpl.isNullOrEmpty(this.issuer);
    }

    private static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    @Override
    @NotNull
    public String name() {
        return this.cfg.name();
    }

    @NotNull
    public String authorizationEndpoint() {
        if (this.hasBaseUrl) {
            return this.metadataRegistry.getAuthorizationEndpoint(this.cfg.baseUrl()).toString();
        }
        return this.authorizationEndpoint;
    }

    @NotNull
    public String tokenEndpoint() {
        if (this.hasBaseUrl) {
            return this.metadataRegistry.getTokenEndpoint(this.cfg.baseUrl()).toString();
        }
        return this.tokenEndpoint;
    }

    @NotNull
    public String clientId() {
        return this.cfg.clientId();
    }

    @Nullable
    public String clientSecret() {
        return this.cfg.clientSecret();
    }

    @NotNull
    public String[] scopes() {
        return this.cfg.scopes();
    }

    @NotNull
    public String[] additionalAuthorizationParameters() {
        return this.cfg.additionalAuthorizationParameters();
    }

    @Nullable
    String baseUrl() {
        return this.cfg.baseUrl();
    }

    @NotNull
    String userInfoUrl() {
        if (this.hasBaseUrl) {
            return this.metadataRegistry.getUserInfoEndpoint(this.cfg.baseUrl()).toString();
        }
        return this.userInfoUrl;
    }

    @NotNull
    URI jwkSetURL() {
        if (this.hasBaseUrl) {
            return this.metadataRegistry.getJWKSetURI(this.cfg.baseUrl());
        }
        return URI.create(this.jwkSetURL);
    }

    @NotNull
    String issuer() {
        if (this.hasBaseUrl) {
            return this.metadataRegistry.getIssuer(this.cfg.baseUrl());
        }
        return this.issuer;
    }

    @ObjectClassDefinition(name="OpenID Connect connection details")
    public static @interface Config {
        public String name();

        public String baseUrl();

        public String authorizationEndpoint();

        public String tokenEndpoint();

        public String userInfoUrl();

        public String jwkSetURL();

        public String issuer();

        public String clientId();

        @AttributeDefinition(type=AttributeType.PASSWORD)
        public String clientSecret();

        public String[] scopes();

        public String[] additionalAuthorizationParameters();

        public String webconsole_configurationFactory_nameHint() default "Name: {name}, base URL: {baseUrl}, clientId: {clientId}";
    }
}

