/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.xing.login;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.auth.xing.api.XingUser;

public class XingLoginUtil {
    public static String getHash(Credentials credentials) {
        SimpleCredentials simpleCredentials;
        Object attribute;
        if (credentials instanceof SimpleCredentials && (attribute = (simpleCredentials = (SimpleCredentials)credentials).getAttribute("xing-hash")) instanceof String) {
            return (String)attribute;
        }
        return null;
    }

    public static String getUser(Credentials credentials) {
        SimpleCredentials simpleCredentials;
        Object attribute;
        if (credentials instanceof SimpleCredentials && (attribute = (simpleCredentials = (SimpleCredentials)credentials).getAttribute("xing-userdata")) instanceof String) {
            try {
                String base64Json = (String)attribute;
                byte[] decoded = Base64.decodeBase64((String)base64Json);
                return new String(decoded, "UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static XingUser fromJson(String json) {
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        return gson.fromJson(json, XingUser.class);
    }

    public static String hash(String json, String secretKey, String hashAlgorithm) throws InvalidKeyException, NoSuchAlgorithmException, UnsupportedEncodingException {
        Gson gson = new Gson();
        ArrayList<String> list = new ArrayList<String>();
        Map map = gson.fromJson(json, Map.class);
        XingLoginUtil.join(map, list, "");
        Collections.sort(list);
        String message = StringUtils.join(list, null);
        byte[] result = XingLoginUtil.hmac(message, secretKey, hashAlgorithm);
        return Hex.encodeHexString((byte[])result);
    }

    private static void join(Map map, List<String> list, String prefix) {
        Set entrySet = map.entrySet();
        for (Map.Entry entry : entrySet) {
            if (entry.getValue() instanceof Map) {
                Map m = (Map)entry.getValue();
                XingLoginUtil.join(m, list, prefix.concat(entry.getKey().toString()));
                continue;
            }
            list.add(prefix.concat(entry.getKey().toString()).concat(entry.getValue().toString()));
        }
    }

    private static byte[] hmac(String message, String secretKey, String hashAlgorithm) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey.getBytes(), hashAlgorithm);
        Mac mac = Mac.getInstance(hashAlgorithm);
        mac.init(secretKeySpec);
        return mac.doFinal(message.getBytes("UTF-8"));
    }
}

