/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.util.CachingDateFormatter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.apache.sling.commons.log.logback.internal.LogConfigManager;
import org.apache.sling.commons.log.logback.internal.Tailer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

public class SlingConfigurationPrinter {
    private static final CachingDateFormatter dateFormatter = new CachingDateFormatter("yyyy-MM-dd HH:mm:ss");
    protected static final String MODE_ZIP = "zip";
    private final LogConfigManager logConfigManager;

    public SlingConfigurationPrinter(@NotNull LogConfigManager logConfigManager) {
        this.logConfigManager = logConfigManager;
    }

    public void printConfiguration(PrintWriter printWriter, String mode) {
        Collection<Appender<ILoggingEvent>> allAppenders = this.logConfigManager.getAllKnownAppenders().values();
        this.dumpLogFileSummary(printWriter, allAppenders);
        if (!MODE_ZIP.equals(mode)) {
            int numOfLines = this.getNumOfLines();
            Tailer tailer = new Tailer(printWriter, numOfLines);
            for (Appender<ILoggingEvent> appender : allAppenders) {
                File file;
                if (!(appender instanceof FileAppender) || !(file = new File(((FileAppender)appender).getFile())).exists()) continue;
                printWriter.print("Log file ");
                printWriter.println(file.getAbsolutePath());
                printWriter.println("--------------------------------------------------");
                if (numOfLines < 0) {
                    SlingConfigurationPrinter.includeWholeFile(printWriter, file);
                } else {
                    try {
                        tailer.tail(file);
                    }
                    catch (IOException e) {
                        this.logConfigManager.internalFailure("Error occurred while processing log file " + String.valueOf(file), e);
                    }
                }
                printWriter.println();
            }
        }
        this.dumpLogbackStatus(printWriter);
    }

    static void includeWholeFile(PrintWriter printWriter, File file) {
        try (FileReader fr = new FileReader(file);){
            int len;
            char[] buffer = new char[512];
            while ((len = fr.read(buffer)) != -1) {
                printWriter.write(buffer, 0, len);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void dumpLogFileSummary(PrintWriter pw, Collection<Appender<ILoggingEvent>> appenders) {
        pw.println("Summary");
        pw.println("=======");
        pw.println();
        int counter = 0;
        String rootDir = this.logConfigManager.getRootDir();
        for (Appender<ILoggingEvent> appender : appenders) {
            File[] files;
            if (!(appender instanceof FileAppender)) continue;
            File file = new File(((FileAppender)appender).getFile());
            File dir = file.getParentFile();
            String baseName = file.getName();
            String absolutePath = dir.getAbsolutePath();
            String displayName = ((FileAppender)appender).getFile();
            if (absolutePath.startsWith(rootDir)) {
                displayName = baseName;
            }
            pw.printf("%d. %s %n", ++counter, displayName);
            for (File f : files = this.getRotatedFiles((FileAppender<ILoggingEvent>)((FileAppender)appender), -1)) {
                pw.printf("  - %s, %s, %s %n", f.getName(), this.humanReadableByteCount(f.length()), this.getModifiedDate(f));
            }
        }
        pw.println();
    }

    @Nullable
    public URL[] getAttachments(String mode) {
        if (MODE_ZIP.equals(mode)) {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (Appender<ILoggingEvent> appender : this.logConfigManager.getAllKnownAppenders().values()) {
                File[] files;
                if (!(appender instanceof FileAppender)) continue;
                for (File f : files = this.getRotatedFiles((FileAppender<ILoggingEvent>)((FileAppender)appender), this.getMaxOldFileCount())) {
                    this.maybeAddToUrlsList(urls, f);
                }
            }
            if (!urls.isEmpty()) {
                return (URL[])urls.toArray(URL[]::new);
            }
        }
        return null;
    }

    protected void maybeAddToUrlsList(List<URL> urls, File f) {
        try {
            urls.add(f.toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    protected File[] getRotatedFiles(FileAppender<ILoggingEvent> app, int maxOldFileCount) {
        File file = new File(app.getFile());
        if (app instanceof RollingFileAppender) {
            int maxCount;
            File dir = file.getParentFile();
            String baseName = file.getName();
            File[] result = dir.listFiles((d, name) -> name.startsWith(baseName));
            Arrays.sort(result, Collections.reverseOrder(Comparator.comparing(File::lastModified)));
            if (maxOldFileCount > 0 && (maxCount = Math.min(this.getMaxOldFileCount(), result.length)) < result.length) {
                File[] resultCopy = new File[maxCount];
                System.arraycopy(result, 0, resultCopy, 0, maxCount);
                return resultCopy;
            }
            return result;
        }
        return new File[]{file};
    }

    private int getNumOfLines() {
        return this.logConfigManager.getNumOfLines();
    }

    private int getMaxOldFileCount() {
        return this.logConfigManager.getMaxOldFileCount();
    }

    private void dumpLogbackStatus(PrintWriter pw) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        List statusList = loggerContext.getStatusManager().getCopyOfStatusList();
        pw.println("Logback Status");
        pw.println("--------------------------------------------------");
        for (Status s : statusList) {
            pw.printf("%s *%s* %s - %s %n", dateFormatter.format(s.getTimestamp()), this.statusLevelAsString(s), SlingConfigurationPrinter.abbreviatedOrigin(s), s.getMessage());
            if (s.getThrowable() == null) continue;
            s.getThrowable().printStackTrace(pw);
        }
        pw.println();
    }

    static String abbreviatedOrigin(Status s) {
        Object o = s.getOrigin();
        if (o == null) {
            return null;
        }
        String fqClassName = o.getClass().getName();
        int lastIndex = fqClassName.lastIndexOf(46);
        if (lastIndex != -1) {
            return fqClassName.substring(lastIndex + 1, fqClassName.length());
        }
        return fqClassName;
    }

    protected String statusLevelAsString(Status s) {
        String statusLevel;
        int effectiveLevel = s.getEffectiveLevel();
        switch (effectiveLevel) {
            case 0: {
                statusLevel = "INFO";
                break;
            }
            case 1: {
                statusLevel = "WARN";
                break;
            }
            case 2: {
                statusLevel = "ERROR";
                break;
            }
            default: {
                statusLevel = null;
            }
        }
        return statusLevel;
    }

    protected String humanReadableByteCount(long bytes) {
        if (bytes < 0L) {
            return "0";
        }
        int unit = 1000;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        char pre = "kMGTPE".charAt(exp - 1);
        return String.format(Locale.ENGLISH, "%.1f %sB", (double)bytes / Math.pow(unit, exp), Character.valueOf(pre));
    }

    protected String getModifiedDate(File f) {
        long modified = f.lastModified();
        if (modified == 0L) {
            return "UNKNOWN";
        }
        return dateFormatter.format(modified);
    }
}

