/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.util.classloaderurl;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.Manifest;
import org.apache.jackrabbit.vault.validation.spi.util.classloaderurl.URLFactory;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public final class CndUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CndUtil.class);

    private CndUtil() {
    }

    public static List<String> resolveJarUrls(List<String> urls) {
        LinkedList<String> resolvedUrls = new LinkedList<String>();
        for (String url : urls) {
            if ((url = url.trim()).endsWith(".jar")) {
                try {
                    URL jarUrl = URLFactory.createURL("jar:" + url + "!/");
                    JarURLConnection jarConnection = (JarURLConnection)jarUrl.openConnection();
                    Manifest manifest = jarConnection.getManifest();
                    String slingNodetypes = manifest.getMainAttributes().getValue("Sling-Nodetypes");
                    if (slingNodetypes == null) {
                        LOGGER.warn("No 'Sling-Nodetypes' header found in manifest of '{}'", (Object)jarUrl);
                        continue;
                    }
                    for (String nodetype : slingNodetypes.split(",")) {
                        resolvedUrls.add(jarUrl.toString() + nodetype.trim());
                    }
                    continue;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not read from JAR " + url, e);
                }
            }
            resolvedUrls.add(url);
        }
        return resolvedUrls;
    }
}

