/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader;

import java.util.Collections;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.sling.jcr.contentloader.LocalRestriction;

public class LocalPrivilege {
    private String privilegeName;
    private boolean allow;
    private boolean deny;
    private Set<LocalRestriction> allowRestrictions = Collections.emptySet();
    private Set<LocalRestriction> denyRestrictions = Collections.emptySet();
    private Privilege privilege;

    public LocalPrivilege(String privilege) {
        this.privilegeName = privilege;
    }

    public void checkPrivilege(AccessControlManager acm) throws RepositoryException {
        this.privilege = acm.privilegeFromName(this.privilegeName);
    }

    public Privilege getPrivilege() {
        return this.privilege;
    }

    public String getName() {
        return this.privilegeName;
    }

    public boolean isAllow() {
        return this.allow;
    }

    public boolean isDeny() {
        return this.deny;
    }

    public void setAllow(boolean allow) {
        this.allow = allow;
    }

    public void setDeny(boolean deny) {
        this.deny = deny;
    }

    public Set<LocalRestriction> getAllowRestrictions() {
        return this.allowRestrictions;
    }

    public void setAllowRestrictions(Set<LocalRestriction> allowRestrictions) {
        this.allowRestrictions = allowRestrictions;
    }

    public Set<LocalRestriction> getDenyRestrictions() {
        return this.denyRestrictions;
    }

    public void setDenyRestrictions(Set<LocalRestriction> denyRestrictions) {
        this.denyRestrictions = denyRestrictions;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LocalPrivilege [privilege=");
        builder.append(this.privilegeName);
        builder.append(", allow=");
        builder.append(this.allow);
        builder.append(", deny=");
        builder.append(this.deny);
        builder.append(", allowRestrictions=");
        builder.append(this.allowRestrictions);
        builder.append(", denyRestrictions=");
        builder.append(this.denyRestrictions);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allow ? 1231 : 1237);
        result = 31 * result + (this.allowRestrictions == null ? 0 : this.allowRestrictions.hashCode());
        result = 31 * result + (this.deny ? 1231 : 1237);
        result = 31 * result + (this.denyRestrictions == null ? 0 : this.denyRestrictions.hashCode());
        result = 31 * result + (this.privilegeName == null ? 0 : this.privilegeName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalPrivilege other = (LocalPrivilege)obj;
        if (this.allow != other.allow) {
            return false;
        }
        if (this.allowRestrictions == null ? other.allowRestrictions != null : !this.allowRestrictions.equals(other.allowRestrictions)) {
            return false;
        }
        if (this.deny != other.deny) {
            return false;
        }
        if (this.denyRestrictions == null ? other.denyRestrictions != null : !this.denyRestrictions.equals(other.denyRestrictions)) {
            return false;
        }
        return !(this.privilegeName == null ? other.privilegeName != null : !this.privilegeName.equals(other.privilegeName));
    }
}

