/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader.internal.readers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jcr.RepositoryException;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.sling.jcr.contentloader.ContentCreator;
import org.apache.sling.jcr.contentloader.ContentReader;
import org.osgi.service.component.annotations.Component;

@Component(service={ContentReader.class}, property={"service.vendor=The Apache Software Foundation", "extensions=zip", "extensions=jar", "contentTypes=application/zip", "contentTypes=application/java-archive"})
public class ZipReader
implements ContentReader {
    private static final String NT_FOLDER = "nt:folder";

    @Override
    public void parse(URL url, ContentCreator creator) throws IOException, RepositoryException {
        this.parse(url.openStream(), creator);
    }

    @Override
    public void parse(InputStream ins, ContentCreator creator) throws IOException, RepositoryException {
        try (ZipInputStream zis = new ZipInputStream(ins);){
            ZipEntry entry;
            creator.createNode(null, NT_FOLDER, null);
            do {
                if ((entry = zis.getNextEntry()) == null) continue;
                if (!entry.isDirectory()) {
                    String name = entry.getName();
                    int pos = name.lastIndexOf(47);
                    if (pos != -1) {
                        creator.switchCurrentNode(name.substring(0, pos), NT_FOLDER);
                    }
                    creator.createFileAndResourceNode(name, (InputStream)new CloseShieldInputStream((InputStream)zis), null, entry.getTime());
                    creator.finishNode();
                    creator.finishNode();
                    if (pos != -1) {
                        creator.finishNode();
                    }
                }
                zis.closeEntry();
            } while (entry != null);
            creator.finishNode();
        }
    }
}

