/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.analyser;

import java.util.List;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.extension.apiregions.api.artifacts.ArtifactRules;
import org.apache.sling.feature.extension.apiregions.api.artifacts.Mode;
import org.apache.sling.feature.extension.apiregions.api.artifacts.VersionRule;
import org.apache.sling.feature.scanner.ArtifactDescriptor;
import org.apache.sling.feature.scanner.BundleDescriptor;

public class CheckArtifactRules
implements AnalyserTask {
    public String getId() {
        return "artifact-rules";
    }

    public String getName() {
        return "Artifact rules analyser task";
    }

    public void execute(AnalyserTaskContext context) throws Exception {
        ArtifactRules rules = ArtifactRules.getArtifactRules(context.getFeature());
        if (rules == null) {
            context.reportExtensionWarning("artifact-rules", "Artifact rules are not specified, unable to validate feature");
        } else {
            for (BundleDescriptor bundle : context.getFeatureDescriptor().getBundleDescriptors()) {
                this.checkArtifact(context, rules.getBundleVersionRules(), rules.getMode(), bundle.getArtifact().getId());
            }
            for (ArtifactDescriptor desc : context.getFeatureDescriptor().getArtifactDescriptors()) {
                this.checkArtifact(context, rules.getArtifactVersionRules(), rules.getMode(), desc.getArtifact().getId());
            }
        }
    }

    void checkArtifact(AnalyserTaskContext context, List<VersionRule> rules, Mode defaultMode, ArtifactId id) {
        for (VersionRule rule : rules) {
            if (rule.getArtifactId() == null || !rule.getArtifactId().isSame(id) || rule.isAllowed(id.getOSGiVersion())) continue;
            String msg = rule.getMessage();
            if (msg == null) {
                msg = "Artifact with version " + id.getVersion() + " is not allowed.";
            }
            Mode m = defaultMode;
            if (rule.getMode() != null) {
                m = rule.getMode();
            }
            if (m == Mode.LENIENT) {
                context.reportArtifactWarning(id, msg);
                continue;
            }
            context.reportArtifactError(id, msg);
        }
    }
}

