/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.identifier;

import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class IdentifierTracker {
    private final TypePredicate referenceable;
    private final IdentifierTracker parent;
    private final String name;
    private String identifier;

    public IdentifierTracker(NodeState root) {
        this.referenceable = new TypePredicate(root, "mix:referenceable");
        this.parent = null;
        this.name = null;
        String uuid = root.getString("jcr:uuid");
        this.identifier = uuid != null && this.referenceable.test(root) ? uuid : "/";
    }

    private IdentifierTracker(IdentifierTracker parent, String name, String uuid) {
        this.referenceable = parent.referenceable;
        this.parent = parent;
        this.name = name;
        this.identifier = uuid;
    }

    public IdentifierTracker getChildTracker(String name, NodeState state) {
        String uuid = state.getString("jcr:uuid");
        if (uuid != null && !this.referenceable.test(state)) {
            uuid = null;
        }
        return new IdentifierTracker(this, name, uuid);
    }

    public String getIdentifier() {
        if (this.identifier == null) {
            this.identifier = PathUtils.concat(this.parent.getIdentifier(), this.name);
        }
        return this.identifier;
    }
}

