/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.tinkerpop.gremlin.process.traversal.GType;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.NumberHelper;

public class AsNumberStep<S>
extends ScalarMapStep<S, Number> {
    private GType typeToken;

    public AsNumberStep(Traversal.Admin traversal) {
        super(traversal);
        this.typeToken = null;
    }

    public AsNumberStep(Traversal.Admin traversal, GType numberToken) {
        super(traversal);
        if (!numberToken.isNumeric()) {
            throw new IllegalArgumentException("asNumber() requires a numeric type token, got " + numberToken);
        }
        this.typeToken = numberToken;
    }

    @Override
    protected Number map(Traverser.Admin<S> traverser) {
        Object object = traverser.get();
        if (object == null) {
            return null;
        }
        Number number = null;
        if (object instanceof String) {
            number = AsNumberStep.parseNumber((String)object);
        } else if (object instanceof Number) {
            number = (Number)object;
        } else if (object instanceof Date) {
            number = ((Date)object).toInstant().toEpochMilli();
        } else if (object instanceof OffsetDateTime) {
            number = ((OffsetDateTime)object).toInstant().toEpochMilli();
        }
        if (number != null) {
            return this.typeToken == null ? (Number)number : (Number)AsNumberStep.castNumber(number, this.typeToken);
        }
        throw new IllegalArgumentException(String.format("Can't parse type %s as number.", object.getClass().getSimpleName()));
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.OBJECT);
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.typeToken != null ? this.typeToken.hashCode() : 0);
        return result;
    }

    @Override
    public AsNumberStep<S> clone() {
        AsNumberStep clone = (AsNumberStep)super.clone();
        clone.typeToken = this.typeToken;
        return clone;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, new Object[0]);
    }

    private static Number parseNumber(String value) {
        if (NumberUtils.isCreatable((String)value.trim())) {
            return NumberUtils.createNumber((String)value.trim());
        }
        throw new NumberFormatException(String.format("Can't parse string '%s' as number.", value));
    }

    private static Number castNumber(Number number, GType numberToken) {
        return NumberHelper.castTo(number, numberToken);
    }
}

