/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.MapHelper;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ReducingBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.function.HashMapSupplier;

public class GroupCountStep<S, E>
extends ReducingBarrierStep<S, Map<E, Long>>
implements TraversalParent,
ByModulating {
    private Traversal.Admin<S, E> keyTraversal = null;

    public GroupCountStep(Traversal.Admin traversal) {
        super(traversal);
        this.setSeedSupplier(HashMapSupplier.instance());
        this.setReducingBiOperator(GroupCountBiOperator.instance());
    }

    @Override
    public Map<E, Long> projectTraverser(Traverser.Admin<S> traverser) {
        HashMap map = new HashMap(1);
        TraversalUtil.produce(traverser, this.keyTraversal).ifProductive(p -> map.put(p, traverser.bulk()));
        return map;
    }

    @Override
    public void addLocalChild(Traversal.Admin<?, ?> groupTraversal) {
        this.keyTraversal = this.integrateChild(groupTraversal);
    }

    @Override
    public List<Traversal.Admin<S, E>> getLocalChildren() {
        return null == this.keyTraversal ? Collections.emptyList() : Collections.singletonList(this.keyTraversal);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.BULK);
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> keyTraversal) throws UnsupportedOperationException {
        if (this.keyTraversal != null) {
            throw new IllegalStateException("GroupCount step can only have one by modulator");
        }
        this.keyTraversal = this.integrateChild(keyTraversal);
    }

    @Override
    public void replaceLocalChild(Traversal.Admin<?, ?> oldTraversal, Traversal.Admin<?, ?> newTraversal) {
        if (null != this.keyTraversal && this.keyTraversal.equals((Object)oldTraversal)) {
            this.keyTraversal = this.integrateChild(newTraversal);
        }
    }

    @Override
    public GroupCountStep<S, E> clone() {
        GroupCountStep clone = (GroupCountStep)super.clone();
        if (null != this.keyTraversal) {
            clone.keyTraversal = this.keyTraversal.clone();
        }
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.integrateChild(this.keyTraversal);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (this.keyTraversal != null) {
            result ^= this.keyTraversal.hashCode();
        }
        return result;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.keyTraversal);
    }

    public static final class GroupCountBiOperator<E>
    implements BinaryOperator<Map<E, Long>>,
    Serializable {
        private static final GroupCountBiOperator INSTANCE = new GroupCountBiOperator();

        @Override
        public Map<E, Long> apply(Map<E, Long> mutatingSeed, Map<E, Long> map) {
            for (Map.Entry<E, Long> entry : map.entrySet()) {
                MapHelper.incr(mutatingSeed, entry.getKey(), entry.getValue());
            }
            return mutatingSeed;
        }

        public static final <E> GroupCountBiOperator<E> instance() {
            return INSTANCE;
        }
    }
}

