/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messagelet.impl;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.messagelet.MessageDrivenObjectSupport;
import org.apache.commons.messagelet.impl.HttpMessageletRequestImpl;
import org.apache.commons.messagelet.impl.HttpMessageletResponseImpl;
import org.apache.commons.messagelet.impl.HttpServletRequestImpl;
import org.apache.commons.messagelet.impl.HttpServletResponseImpl;
import org.apache.commons.messenger.Messenger;
import org.apache.commons.messenger.MessengerListener;

public class MessageHttpServletDispatcher
extends MessageDrivenObjectSupport
implements MessengerListener {
    private HttpMessageletRequestImpl request;
    private HttpMessageletResponseImpl response;
    private Messenger messenger;
    private String path;

    public MessageHttpServletDispatcher() {
    }

    public MessageHttpServletDispatcher(String path) {
        this();
        this.path = path;
    }

    public void init() throws ServletException {
        this.request = new HttpMessageletRequestImpl(this.createHttpServletRequest());
        this.response = new HttpMessageletResponseImpl(new HttpServletResponseImpl());
    }

    public void setMessenger(Messenger messenger) {
        this.messenger = messenger;
    }

    public void onMessage(Message message) {
        try {
            this.response.setReplyToDestination(message.getJMSReplyTo());
        }
        catch (JMSException e) {
            this.log("Could not find JMS replyTo destination", e);
            this.response.setReplyToDestination(null);
        }
        try {
            this.request.setMessage(message);
            this.request.setMessenger(this.messenger);
            this.response.setReplyMessenger(this.messenger);
            this.response.reset();
            this.getServletContext().getRequestDispatcher(this.getPath()).include((ServletRequest)this.request, (ServletResponse)this.response);
            this.response.finish();
        }
        catch (Throwable e) {
            this.handleException(message, e);
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    protected void handleException(Message message, Throwable t) {
        this.log("Caught exception processing message: " + message, t);
    }

    protected HttpServletRequestImpl createHttpServletRequest() {
        HttpServletRequestImpl request = new HttpServletRequestImpl(this.getServletContext());
        request.setRequestURI(this.path);
        int idx = this.path.indexOf(63);
        if (idx >= 0) {
            request.setQueryString(this.path.substring(idx + 1));
            request.setPathInfo(this.path.substring(0, idx));
        }
        return request;
    }
}

