/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.Turbine;
import org.apache.turbine.modules.Action;
import org.apache.turbine.modules.GenericLoader;
import org.apache.turbine.services.assemblerbroker.AssemblerBrokerService;
import org.apache.turbine.services.assemblerbroker.TurbineAssemblerBroker;
import org.apache.turbine.util.ObjectUtils;
import org.apache.turbine.util.RunData;

public class ActionLoader
extends GenericLoader {
    private static final long serialVersionUID = -2285549057406921958L;
    private static Log log = LogFactory.getLog((Class)ActionLoader.class);
    private static ActionLoader instance = new ActionLoader(Turbine.getConfiguration().getInt("action.cache.size", 20));
    private static AssemblerBrokerService ab = TurbineAssemblerBroker.getService();

    private ActionLoader() {
    }

    private ActionLoader(int i) {
        super(i);
    }

    private void addInstance(String name, Action action) {
        if (this.cache()) {
            this.put(name, action);
        }
    }

    public void exec(RunData data, String name) throws Exception {
        this.getInstance(name).perform(data);
    }

    public Action getInstance(String name) throws Exception {
        Action action = null;
        if (this.cache() && this.containsKey(name)) {
            action = (Action)this.get(name);
            log.debug((Object)("Found Action " + name + " in the cache!"));
        } else {
            log.debug((Object)("Loading Action " + name + " from the Assembler Broker"));
            try {
                action = (Action)ab.getAssembler("action", name);
            }
            catch (ClassCastException cce) {
                action = null;
            }
            if (action == null) {
                List packages = Turbine.getConfiguration().getList("module.packages");
                ObjectUtils.addOnce(packages, GenericLoader.getBasePackage());
                throw new ClassNotFoundException("\n\n\tRequested Action not found: " + name + "\n\tTurbine looked in the following " + "modules.packages path: \n\t" + packages.toString() + "\n");
            }
            if (this.cache()) {
                this.addInstance(name, action);
            }
        }
        return action;
    }

    public static ActionLoader getInstance() {
        return instance;
    }
}

