/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.layouts;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ecs.ConcreteElement;
import org.apache.turbine.modules.Layout;
import org.apache.turbine.modules.ScreenLoader;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.template.TemplateNavigation;
import org.apache.velocity.context.Context;

public class VelocityECSLayout
extends Layout {
    private static Log log = LogFactory.getLog((Class)VelocityECSLayout.class);
    private String prefix = "layouts/";
    private static boolean hasWarned = false;

    public VelocityECSLayout() {
        if (!hasWarned) {
            log.warn((Object)"The VelocityECSLayout is deprecated. Please switch to VelocityOnlyLayout.");
            hasWarned = true;
        }
    }

    public void doBuild(RunData data) throws Exception {
        Context context = TurbineVelocity.getContext(data);
        String screenName = data.getScreen();
        log.debug((Object)("Loading Screen " + screenName));
        ConcreteElement results = ScreenLoader.getInstance().eval(data, screenName);
        String returnValue = results == null ? "" : results.toString();
        context.put("screen_placeholder", (Object)returnValue);
        context.put("navigation", (Object)new TemplateNavigation(data));
        String templateName = data.getTemplateInfo().getLayoutTemplate();
        log.debug((Object)("Now trying to render layout " + templateName));
        data.getPage().getBody().addElement(TurbineVelocity.handleRequest(context, this.prefix + templateName));
    }
}

