/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.om.security.peer;

import com.workingdogs.village.Record;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;
import org.apache.turbine.om.security.Permission;
import org.apache.turbine.om.security.Role;
import org.apache.turbine.om.security.TurbinePermission;
import org.apache.turbine.om.security.TurbineRole;
import org.apache.turbine.om.security.peer.RolePermissionPeer;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.util.db.map.TurbineMapBuilder;
import org.apache.turbine.util.security.DataBackendException;
import org.apache.turbine.util.security.PermissionSet;

public class PermissionPeer
extends BasePeer {
    private static final long serialVersionUID = 2762005892291909743L;
    private static final TurbineMapBuilder MAP_BUILDER;
    private static final String TABLE_NAME;
    public static final String PERMISSION_ID;
    public static final String OBJECTDATA;
    public static final String NAME;

    public static PermissionSet retrieveSet(Criteria criteria) throws Exception {
        List results = PermissionPeer.doSelect(criteria);
        PermissionSet ps = new PermissionSet();
        for (int i = 0; i < results.size(); ++i) {
            ps.add((Permission)results.get(i));
        }
        return ps;
    }

    public static PermissionSet retrieveSet(Role role) throws Exception {
        Criteria criteria = new Criteria();
        criteria.add(RolePermissionPeer.ROLE_ID, (Object)((TurbineRole)role).getPrimaryKey());
        criteria.addJoin(RolePermissionPeer.PERMISSION_ID, PERMISSION_ID);
        return PermissionPeer.retrieveSet(criteria);
    }

    public static List doSelect(Criteria criteria) throws TorqueException {
        try {
            criteria.addSelectColumn(PERMISSION_ID).addSelectColumn(NAME).addSelectColumn(OBJECTDATA);
            if (criteria.getOrderByColumns() == null || criteria.getOrderByColumns().size() == 0) {
                criteria.addAscendingOrderByColumn(NAME);
            }
            List rows = BasePeer.doSelect((Criteria)criteria);
            ArrayList<Permission> results = new ArrayList<Permission>();
            for (int i = 0; i < rows.size(); ++i) {
                Permission obj = TurbineSecurity.getPermissionInstance(null);
                Record row = (Record)rows.get(i);
                ((TurbinePermission)obj).setPrimaryKey((ObjectKey)new NumberKey(row.getValue(1).asInt()));
                ((TurbinePermission)obj).setName(row.getValue(2).asString());
                results.add(obj);
            }
            return results;
        }
        catch (Exception ex) {
            throw new TorqueException((Throwable)ex);
        }
    }

    public static Criteria buildCriteria(Permission permission) {
        Criteria criteria = new Criteria();
        if (!((BaseObject)permission).isNew()) {
            criteria.add(PERMISSION_ID, (Object)((BaseObject)permission).getPrimaryKey());
        }
        criteria.add(NAME, (Object)((TurbinePermission)permission).getName());
        return criteria;
    }

    public static void doUpdate(Criteria criteria) throws TorqueException {
        Criteria selectCriteria = new Criteria(2);
        selectCriteria.put((Object)PERMISSION_ID, criteria.remove(PERMISSION_ID));
        BasePeer.doUpdate((Criteria)selectCriteria, (Criteria)criteria);
    }

    public static boolean checkExists(Permission permission) throws DataBackendException, Exception {
        Criteria criteria = new Criteria();
        criteria.addSelectColumn(PERMISSION_ID);
        criteria.add(NAME, (Object)((TurbinePermission)permission).getName());
        List results = BasePeer.doSelect((Criteria)criteria);
        if (results.size() > 1) {
            throw new DataBackendException("Multiple permissions named '" + ((TurbinePermission)permission).getName() + "' exist!");
        }
        return results.size() == 1;
    }

    public static String getTableName() {
        return TABLE_NAME;
    }

    public static String getColumnName(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append(TABLE_NAME);
        sb.append(".");
        sb.append(name);
        return sb.toString();
    }

    public static final Vector getDifference(Vector some, Vector all) {
        Vector clone = (Vector)all.clone();
        Enumeration e = some.elements();
        block0: while (e.hasMoreElements()) {
            Permission tmp = (Permission)e.nextElement();
            Enumeration f = clone.elements();
            while (f.hasMoreElements()) {
                Permission tmp2 = (Permission)f.nextElement();
                if (((BaseObject)tmp).getPrimaryKey() != ((BaseObject)tmp2).getPrimaryKey()) continue;
                clone.removeElement(tmp2);
                continue block0;
            }
        }
        return clone;
    }

    static {
        try {
            MAP_BUILDER = (TurbineMapBuilder)Torque.getMapBuilder((String)TurbineMapBuilder.class.getName());
        }
        catch (TorqueException e) {
            log.error((Object)"Could not initialize Peer", (Throwable)e);
            throw new RuntimeException(e);
        }
        TABLE_NAME = MAP_BUILDER.getTablePermission();
        PERMISSION_ID = MAP_BUILDER.getPermission_PermissionId();
        NAME = MAP_BUILDER.getPermission_Name();
        OBJECTDATA = MAP_BUILDER.getPermission_ObjectData();
    }
}

