/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.model;

import org.apache.turbine.services.intake.IntakeException;
import org.apache.turbine.services.intake.model.Field;
import org.apache.turbine.services.intake.model.Group;
import org.apache.turbine.services.intake.validator.BooleanValidator;
import org.apache.turbine.services.intake.xmlmodel.XmlField;

public class BooleanField
extends Field {
    public BooleanField(XmlField field, Group group) throws IntakeException {
        super(field, group);
    }

    public void setDefaultValue(String prop) {
        this.defaultValue = null;
        if (prop == null) {
            return;
        }
        this.defaultValue = Boolean.valueOf(prop);
    }

    public void setEmptyValue(String prop) {
        this.emptyValue = null;
        if (prop == null) {
            return;
        }
        this.emptyValue = Boolean.valueOf(prop);
    }

    protected Object getSafeEmptyValue() {
        if (this.isMultiValued) {
            return new boolean[0];
        }
        return null == this.getEmptyValue() ? Boolean.FALSE : this.getEmptyValue();
    }

    protected String getDefaultValidator() {
        return BooleanValidator.class.getName();
    }

    protected void doSetValue() {
        if (this.isMultiValued) {
            Boolean[] inputs = this.parser.getBooleanObjects(this.getKey());
            boolean[] values = new boolean[inputs.length];
            for (int i = 0; i < inputs.length; ++i) {
                values[i] = inputs[i] == null ? ((Boolean)this.getEmptyValue()).booleanValue() : inputs[i].booleanValue();
            }
            this.setTestValue(values);
        } else {
            this.setTestValue(this.parser.getBooleanObject(this.getKey(), (Boolean)this.getEmptyValue()));
        }
    }

    public boolean booleanValue() {
        boolean result = false;
        try {
            result = (Boolean)this.getValue();
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
        return result;
    }
}

