/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.model;

import org.apache.commons.lang.StringUtils;
import org.apache.turbine.services.intake.IntakeException;
import org.apache.turbine.services.intake.model.Field;
import org.apache.turbine.services.intake.model.Group;
import org.apache.turbine.services.intake.validator.StringValidator;
import org.apache.turbine.services.intake.xmlmodel.XmlField;

public class StringField
extends Field {
    public StringField(XmlField field, Group group) throws IntakeException {
        super(field, group);
    }

    protected String getDefaultValidator() {
        return StringValidator.class.getName();
    }

    public void setDefaultValue(String prop) {
        this.defaultValue = prop;
    }

    public void setEmptyValue(String prop) {
        this.emptyValue = prop;
    }

    protected void doSetValue() {
        if (this.isMultiValued) {
            String[] ss = this.parser.getStrings(this.getKey());
            String[] sval = new String[ss.length];
            for (int i = 0; i < ss.length; ++i) {
                sval[i] = StringUtils.isNotEmpty((String)ss[i]) ? ss[i] : (String)this.getEmptyValue();
            }
            this.setTestValue(sval);
        } else {
            String val = this.parser.getString(this.getKey());
            this.setTestValue(StringUtils.isNotEmpty((String)val) ? val : (String)this.getEmptyValue());
        }
    }

    public void setRequired(boolean v, String message) {
        this.required = v;
        if (v) {
            if (this.isMultiValued) {
                String[] ss = (String[])this.getTestValue();
                if (ss == null || ss.length == 0) {
                    this.validFlag = false;
                    this.message = message;
                } else {
                    boolean set = false;
                    for (int i = 0; i < ss.length && !(set |= StringUtils.isNotEmpty((String)ss[i])); ++i) {
                    }
                    if (!set) {
                        this.validFlag = false;
                        this.message = message;
                    }
                }
            } else if (!this.setFlag || StringUtils.isEmpty((String)((String)this.getTestValue()))) {
                this.validFlag = false;
                this.message = message;
            }
        }
    }
}

