/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.validator;

import java.util.Map;
import org.apache.torque.om.NumberKey;
import org.apache.turbine.services.intake.validator.Constraint;
import org.apache.turbine.services.intake.validator.InvalidMaskException;
import org.apache.turbine.services.intake.validator.NumberValidator;
import org.apache.turbine.services.intake.validator.ValidationException;

public class NumberKeyValidator
extends NumberValidator {
    private static String INVALID_NUMBER = "Entry was not valid.";
    private NumberKey minValue;
    private NumberKey maxValue;

    public NumberKeyValidator(Map paramMap) throws InvalidMaskException {
        this();
        this.init(paramMap);
    }

    public NumberKeyValidator() {
    }

    protected void doInit(Map paramMap) {
        String param;
        this.minValue = null;
        this.maxValue = null;
        Constraint constraint = (Constraint)paramMap.get("minValue");
        if (constraint != null) {
            param = constraint.getValue();
            this.minValue = new NumberKey(param);
            this.minValueMessage = constraint.getMessage();
        }
        if ((constraint = (Constraint)paramMap.get("maxValue")) != null) {
            param = constraint.getValue();
            this.maxValue = new NumberKey(param);
            this.maxValueMessage = constraint.getMessage();
        }
    }

    protected String getDefaultInvalidNumberMessage() {
        return INVALID_NUMBER;
    }

    public void assertValidity(String testValue) throws ValidationException {
        NumberKey nk = null;
        try {
            nk = new NumberKey(testValue);
        }
        catch (RuntimeException e) {
            this.errorMessage = this.invalidNumberMessage;
            throw new ValidationException(this.invalidNumberMessage);
        }
        if (this.minValue != null && nk.compareTo((Object)this.minValue) < 0) {
            this.errorMessage = this.minValueMessage;
            throw new ValidationException(this.minValueMessage);
        }
        if (this.maxValue != null && nk.compareTo((Object)this.maxValue) > 0) {
            this.errorMessage = this.maxValueMessage;
            throw new ValidationException(this.maxValueMessage);
        }
    }

    public NumberKey getMinValue() {
        return this.minValue;
    }

    public void setMinValue(NumberKey minValue) {
        this.minValue = minValue;
    }

    public NumberKey getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(NumberKey maxValue) {
        this.maxValue = maxValue;
    }
}

