/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.jsp;

import java.io.File;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.jsp.JspService;
import org.apache.turbine.services.pull.tools.TemplateLink;
import org.apache.turbine.services.template.BaseTemplateEngineService;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;

public class TurbineJspService
extends BaseTemplateEngineService
implements JspService {
    private String[] templatePaths;
    private String[] relativeTemplatePaths;
    private int bufferSize;
    private static Log log = LogFactory.getLog((Class)TurbineJspService.class);

    public void init() throws InitializationException {
        try {
            this.initJsp();
            this.registerConfiguration("jsp");
            this.setInit(true);
        }
        catch (Exception e) {
            throw new InitializationException("TurbineJspService failed to initialize", e);
        }
    }

    public void init(ServletConfig config) throws InitializationException {
        this.init();
    }

    public void addDefaultObjects(RunData data) {
        HttpServletRequest req = data.getRequest();
        TemplateLink templateLink = new TemplateLink();
        templateLink.init(data);
        req.setAttribute("link", (Object)templateLink);
        req.setAttribute("rundata", (Object)data);
    }

    public int getDefaultBufferSize() {
        return this.bufferSize;
    }

    public void handleRequest(RunData data, String templateName) throws TurbineException {
        this.handleRequest(data, templateName, false);
    }

    public void handleRequest(RunData data, String templateName, boolean isForward) throws TurbineException {
        String relativeTemplateName = this.getRelativeTemplateName(templateName);
        if (StringUtils.isEmpty((String)relativeTemplateName)) {
            throw new TurbineException("Template " + templateName + " not found in template paths");
        }
        RequestDispatcher dispatcher = data.getServletContext().getRequestDispatcher(relativeTemplateName);
        try {
            if (isForward) {
                dispatcher.forward((ServletRequest)data.getRequest(), (ServletResponse)data.getResponse());
            } else {
                data.getOut().flush();
                dispatcher.include((ServletRequest)data.getRequest(), (ServletResponse)data.getResponse());
            }
        }
        catch (Exception e) {
            try {
                data.getOut().print("Error encountered processing a template: " + templateName);
                e.printStackTrace(data.getOut());
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw new TurbineException("Error encountered processing a template: " + templateName, e);
        }
    }

    private void initJsp() throws Exception {
        Configuration config = this.getConfiguration();
        this.relativeTemplatePaths = config.getStringArray("templates");
        this.templatePaths = new String[this.relativeTemplatePaths.length];
        for (int i = 0; i < this.relativeTemplatePaths.length; ++i) {
            this.relativeTemplatePaths[i] = this.warnAbsolute(this.relativeTemplatePaths[i]);
            this.templatePaths[i] = Turbine.getRealPath(this.relativeTemplatePaths[i]);
        }
        this.bufferSize = config.getInt("buffer.size", 8192);
    }

    public boolean templateExists(String template) {
        for (int i = 0; i < this.templatePaths.length; ++i) {
            if (!this.templateExists(this.templatePaths[i], template)) continue;
            return true;
        }
        return false;
    }

    private boolean templateExists(String path, String template) {
        return new File(path, template).exists();
    }

    public String getRelativeTemplateName(String template) {
        template = this.warnAbsolute(template);
        for (int i = 0; i < this.templatePaths.length; ++i) {
            if (!this.templateExists(this.templatePaths[i], template)) continue;
            return this.relativeTemplatePaths[i] + "/" + template;
        }
        return null;
    }

    private String warnAbsolute(String template) {
        if (template.startsWith("/")) {
            log.warn((Object)("Template " + template + " has a leading /, which is wrong!"));
            return template.substring(1);
        }
        return template;
    }
}

